/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.io.Serializable;
import kom.itbeankit.mm.compression.mva.model.ByteMap;
import kom.itbeankit.mm.compression.mva.model.ThreeLayerByteMap;
import kom.itbeankit.mm.compression.mva.model.YUVByteMap;
import kom.itbeankit.util.Convert;

public class RGBByteMap
extends ThreeLayerByteMap
implements Cloneable,
Serializable {
    public RGBByteMap(int n, int n2) {
        super(n, n2);
    }

    public RGBByteMap(int n, int n2, byte by, byte by2, byte by3) {
        super(n, n2);
        this.Map0.fill(0, n - 1, 0, n2 - 1, by);
        this.Map1.fill(0, n - 1, 0, n2 - 1, by2);
        this.Map2.fill(0, n - 1, 0, n2 - 1, by3);
    }

    public RGBByteMap(RGBByteMap rGBByteMap, int n, int n2, int n3, int n4) {
        this(n2, n);
        this.copy(rGBByteMap, n3, n4, n3 + n2 - 1, n4 + n - 1);
    }

    public void array2rgb(int[] nArray) {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = nArray[n * this.width + n2] & 0xFFFFFF;
                this.Map0.theMap[n2][n] = Convert.int2byte((n3 & 0xFF0000) / 65536);
                this.Map1.theMap[n2][n] = Convert.int2byte((n3 & 0xFF00) / 256);
                this.Map2.theMap[n2][n] = Convert.int2byte(n3 & 0xFF);
                ++n2;
            }
            ++n;
        }
    }

    public void average(int n) {
        this.Map1.reduce(n);
        this.Map1.extend(0, 0);
        this.Map2.reduce(n);
        this.Map2.extend(0, 0);
    }

    public Object clone() {
        RGBByteMap rGBByteMap = new RGBByteMap(this.width, this.height);
        rGBByteMap.Map0 = (ByteMap)this.Map0.clone();
        rGBByteMap.Map1 = (ByteMap)this.Map1.clone();
        rGBByteMap.Map2 = (ByteMap)this.Map2.clone();
        return rGBByteMap;
    }

    public void copy(RGBByteMap rGBByteMap, int n, int n2, int n3, int n4) {
        this.Map0.copy(rGBByteMap.Map0, n, n2, n3, n4, 0, 0);
        this.Map1.copy(rGBByteMap.Map1, n, n2, n3, n4, 0, 0);
        this.Map2.copy(rGBByteMap.Map2, n, n2, n3, n4, 0, 0);
    }

    public int[] rgb2array() {
        int[] nArray = new int[this.height * this.width];
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                nArray[n * this.width + n2] = -16777216 + Convert.byte2int(this.Map0.theMap[n2][n]) * 65536 + Convert.byte2int(this.Map1.theMap[n2][n]) * 256 + Convert.byte2int(this.Map2.theMap[n2][n]);
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public YUVByteMap rgb2yuv() {
        YUVByteMap yUVByteMap = new YUVByteMap(this.width, this.height);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                byte[] byArray = this.rgb2yuv(this.Map0.theMap[n2][n], this.Map1.theMap[n2][n], this.Map2.theMap[n2][n]);
                yUVByteMap.Map0.theMap[n2][n] = byArray[0];
                yUVByteMap.Map1.theMap[n2][n] = byArray[1];
                yUVByteMap.Map2.theMap[n2][n] = byArray[2];
                ++n2;
            }
            ++n;
        }
        return yUVByteMap;
    }

    public byte[] rgb2yuv(byte by, byte by2, byte by3) {
        int n = Convert.byte2int(by);
        int n2 = Convert.byte2int(by2);
        int n3 = Convert.byte2int(by3);
        long l = 16828 * n + 33039 * n2 + 6417 * n3;
        long l2 = 28775 * n - 24095 * n2 - 4680 * n3;
        long l3 = -9708 * n - 19060 * n2 + 28768 * n3;
        int n4 = Convert.chop((int)(l >> 16) + 16);
        int n5 = Convert.chop((int)(l3 >> 16) + 128);
        int n6 = Convert.chop((int)(l2 >> 16) + 128);
        byte[] byArray = new byte[]{Convert.int2byte(n4), Convert.int2byte(n5), Convert.int2byte(n6)};
        return byArray;
    }
}

