/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.ColorChooserPanel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.plaf.ColorChooserUI;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicHSVChooserPanel;
import com.sun.java.swing.plaf.basic.BasicRGBChooserPanel;
import com.sun.java.swing.preview.JColorChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class BasicColorChooserUI
extends ColorChooserUI
implements PropertyChangeListener {
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    Hashtable panels;
    boolean settingAllPanels = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults(jComponent);
        this.chooser = (JColorChooser)jComponent;
        this.tabbedPane = new JTabbedPane();
        this.panels = new Hashtable();
        this.chooser.setLayout(this.createSinglePaneLayout());
        ColorChooserPanel colorChooserPanel = new BasicHSVChooserPanel();
        this.chooser.addChooserPanel("HSV", colorChooserPanel);
        colorChooserPanel = new BasicRGBChooserPanel();
        this.chooser.addChooserPanel("RGB", colorChooserPanel);
        this.installListeners(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.chooser.removeChooserPanel("HSV");
        this.panels = null;
        this.chooser = null;
        this.tabbedPane = null;
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        if (this.panels.size() == 1) {
            dimension = ((ColorChooserPanel)this.panels.elements().nextElement()).getPreferredSize();
        } else {
            if (this.panels.size() > 1) {
                return this.tabbedPane.getPreferredSize();
            }
            dimension = new Dimension(0, 0);
        }
        return dimension;
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    protected void installListeners(JComponent jComponent) {
        this.chooser.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JComponent jComponent) {
        this.chooser.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("ColorChooserPanel.COLOR_PROPERTY") && !this.settingAllPanels) {
            if (this.chooser.getColor() != propertyChangeEvent.getNewValue()) {
                this.chooser.setColor((Color)propertyChangeEvent.getNewValue());
                return;
            }
        } else if (propertyChangeEvent.getPropertyName().equals("color")) {
            Enumeration enumeration = this.panels.elements();
            this.settingAllPanels = true;
            while (enumeration.hasMoreElements()) {
                ColorChooserPanel colorChooserPanel = (ColorChooserPanel)enumeration.nextElement();
                if (colorChooserPanel.getColor() == propertyChangeEvent.getNewValue()) continue;
                colorChooserPanel.setColor((Color)propertyChangeEvent.getNewValue());
            }
            this.settingAllPanels = false;
        }
    }

    public void addChooserPanel(String string, ColorChooserPanel colorChooserPanel) {
        if (colorChooserPanel != null && string != null) {
            colorChooserPanel.installChooserPanel();
            if (this.panels.size() == 0 && this.chooser.getColor() == null) {
                this.chooser.setColor(colorChooserPanel.getColor());
            } else {
                colorChooserPanel.setColor(this.chooser.getColor());
            }
            this.panels.put(string, colorChooserPanel);
            colorChooserPanel.addPropertyChangeListener(this);
            if (this.panels.size() == 2) {
                this.switchToMultiplePanelSetup();
                return;
            }
            if (this.panels.size() <= 1) {
                this.chooser.add((Component)colorChooserPanel, "Center");
                return;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new CenterLayout());
            jPanel.add(colorChooserPanel);
            this.tabbedPane.addTab(string, jPanel);
        }
    }

    public ColorChooserPanel removeChooserPanel(String string) {
        ColorChooserPanel colorChooserPanel = null;
        if (string != null) {
            colorChooserPanel = (ColorChooserPanel)this.panels.remove(string);
            if (this.panels.size() > 1) {
                this.tabbedPane.removeTabAt(this.tabbedPane.indexOfTab(string));
            } else if (this.panels.size() == 0) {
                this.chooser.remove(colorChooserPanel);
            }
            colorChooserPanel.uninstallChooserPanel();
            colorChooserPanel.removePropertyChangeListener(this);
            if (colorChooserPanel != null && this.panels.size() == 1) {
                this.switchToSinglePanelSetup();
            }
        }
        return colorChooserPanel;
    }

    protected void switchToMultiplePanelSetup() {
        this.chooser.setLayout(this.createTabbedPaneLayout());
        Enumeration enumeration = this.panels.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.chooser.remove((Component)this.panels.get(string));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new CenterLayout());
            jPanel.add((Component)this.panels.get(string));
            this.tabbedPane.addTab(string, jPanel);
        }
        this.chooser.add((Component)this.tabbedPane, "Center");
    }

    protected void switchToSinglePanelSetup() {
        this.chooser.remove(this.tabbedPane);
        int n = 0;
        while (n < this.panels.size()) {
            this.tabbedPane.removeTabAt(0);
            ++n;
        }
        this.chooser.setLayout(this.createSinglePaneLayout());
        Enumeration enumeration = this.panels.elements();
        if (enumeration.hasMoreElements()) {
            this.chooser.add((Component)enumeration.nextElement(), "Center");
        }
    }

    protected LayoutManager createSinglePaneLayout() {
        return new CenterLayout();
    }

    protected LayoutManager createTabbedPaneLayout() {
        return new BorderLayout();
    }

    public static class CenterLayout
    implements LayoutManager,
    Serializable {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Component component = container.getComponent(0);
            if (component != null) {
                return component.getPreferredSize();
            }
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            try {
                Component component = container.getComponent(0);
                component.setSize(component.getPreferredSize());
                Dimension dimension = component.getSize();
                Dimension dimension2 = container.getSize();
                int n = dimension2.width / 2 - dimension.width / 2;
                int n2 = dimension2.height / 2 - dimension.height / 2;
                component.setBounds(n, n2, dimension.width, dimension.height);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

