/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.DesktopManager;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDesktopPane;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.DesktopIconUI;
import com.sun.java.swing.plaf.basic.BasicInternalFrameTitlePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.EventListener;

public class BasicDesktopIconUI
extends DesktopIconUI
implements Serializable {
    JInternalFrame.JDesktopIcon desktopIcon;
    JComponent iconPane;
    EventListener mml;
    JInternalFrame frame;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults(this.desktopIcon);
        this.installComponents(this.desktopIcon);
        this.installListeners(this.desktopIcon);
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        this.installDefaults(this.desktopIcon);
        this.uninstallComponents(this.desktopIcon);
        this.uninstallListeners(this.desktopIcon);
        this.desktopIcon = null;
        this.frame = null;
    }

    protected void installComponents(JInternalFrame.JDesktopIcon jDesktopIcon) {
        this.frame = jDesktopIcon.getInternalFrame();
        this.iconPane = new BasicInternalFrameTitlePane(this.frame);
        jDesktopIcon.setLayout(new BorderLayout());
        jDesktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents(JInternalFrame.JDesktopIcon jDesktopIcon) {
        jDesktopIcon.setLayout(null);
        jDesktopIcon.remove(this.iconPane);
    }

    protected void installListeners(JInternalFrame.JDesktopIcon jDesktopIcon) {
        this.mml = this.createMotionListener(this.desktopIcon);
        jDesktopIcon.addMouseMotionListener((MouseMotionListener)this.mml);
        jDesktopIcon.addMouseListener((MouseListener)this.mml);
    }

    protected void uninstallListeners(JInternalFrame.JDesktopIcon jDesktopIcon) {
        jDesktopIcon.removeMouseMotionListener((MouseMotionListener)this.mml);
        jDesktopIcon.removeMouseListener((MouseListener)this.mml);
    }

    protected void installDefaults(JInternalFrame.JDesktopIcon jDesktopIcon) {
        LookAndFeel.installBorder(jDesktopIcon, "DesktopIcon.border");
    }

    protected void uninstallDefaults(JInternalFrame.JDesktopIcon jDesktopIcon) {
    }

    protected MotionListener createMotionListener(JInternalFrame.JDesktopIcon jDesktopIcon) {
        return new MotionListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        int n = 157;
        int n2 = 18;
        if (border != null) {
            n2 += border.getBorderInsets((Component)jInternalFrame).bottom + border.getBorderInsets((Component)jInternalFrame).top;
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.iconPane.getMinimumSize();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.iconPane.getMaximumSize();
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public class MotionListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = BasicDesktopIconUI.this.desktopIcon.getBounds();
            try {
                BasicDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            if (BasicDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)BasicDesktopIconUI.this.desktopIcon.getParent()).moveToFront(BasicDesktopIconUI.this.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && BasicDesktopIconUI.this.frame.isIconifiable() && BasicDesktopIconUI.this.frame.isIcon()) {
                BasicDesktopIconUI.this.deiconize();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = BasicDesktopIconUI.this.desktopIcon.getInsets();
            int n = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int n2 = ((JComponent)BasicDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int n3 = this.startingBounds.x - (this._x - point.x);
            int n4 = this.startingBounds.y - (this._y - point.y);
            if (n3 + insets.left <= -this.__x) {
                n3 = -this.__x - insets.left;
            }
            if (n4 + insets.top <= -this.__y) {
                n4 = -this.__y - insets.top;
            }
            if (n3 + this.__x + insets.right > n) {
                n3 = n - this.__x - insets.right;
            }
            if (n4 + this.__y + insets.bottom > n2) {
                n4 = n2 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = BasicDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.setBoundsForFrame(BasicDesktopIconUI.this.desktopIcon, n3, n4, BasicDesktopIconUI.this.desktopIcon.getWidth(), BasicDesktopIconUI.this.desktopIcon.getHeight());
                return;
            }
            this.moveAndRepaint(BasicDesktopIconUI.this.desktopIcon, n3, n4, BasicDesktopIconUI.this.desktopIcon.getWidth(), BasicDesktopIconUI.this.desktopIcon.getHeight());
        }

        public void moveAndRepaint(JComponent jComponent, int n, int n2, int n3, int n4) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n, n2, n3, n4);
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public MotionListener() {
            BasicDesktopIconUI.this = BasicDesktopIconUI.this;
        }
    }
}

