/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;

public class WindowsIconFactory
implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon createFrameCloseIcon() {
        if (frame_closeIcon == null) {
            frame_closeIcon = new CloseIcon();
        }
        return frame_closeIcon;
    }

    public static Icon createFrameIconifyIcon() {
        if (frame_iconifyIcon == null) {
            frame_iconifyIcon = new IconifyIcon();
        }
        return frame_iconifyIcon;
    }

    public static Icon createFrameMaximizeIcon() {
        if (frame_maxIcon == null) {
            frame_maxIcon = new MaximizeIcon();
        }
        return frame_maxIcon;
    }

    public static Icon createFrameMinimizeIcon() {
        if (frame_minIcon == null) {
            frame_minIcon = new MinimizeIcon();
        }
        return frame_minIcon;
    }

    public static Icon createFrameResizeIcon() {
        if (frame_resizeIcon == null) {
            frame_resizeIcon = new ResizeIcon();
        }
        return frame_resizeIcon;
    }

    private static class CloseIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine(4, 3, 10, 9);
            graphics.drawLine(5, 3, 11, 9);
            graphics.drawLine(10, 3, 4, 9);
            graphics.drawLine(11, 3, 5, 9);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        CloseIcon() {
        }
    }

    private static class IconifyIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawRect(4, this.height - 7, 6, 1);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        IconifyIcon() {
        }
    }

    private static class MaximizeIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawRect(3, 2, 8, 8);
            graphics.drawLine(3, 3, 11, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        MaximizeIcon() {
        }
    }

    private static class MinimizeIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawRect(5, 2, 5, 5);
            graphics.drawLine(5, 3, 10, 3);
            graphics.drawRect(3, 5, 5, 5);
            graphics.drawLine(3, 6, 7, 6);
            graphics.setColor(BasicGraphicsUtils.control);
            graphics.fillRect(4, 7, 4, 3);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        MinimizeIcon() {
        }
    }

    private static class ResizeIcon
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BasicGraphicsUtils.controlHighlight);
            graphics.drawLine(0, 11, 11, 0);
            graphics.drawLine(4, 11, 11, 4);
            graphics.drawLine(8, 11, 11, 8);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.drawLine(1, 11, 11, 1);
            graphics.drawLine(2, 11, 11, 2);
            graphics.drawLine(5, 11, 11, 5);
            graphics.drawLine(6, 11, 11, 6);
            graphics.drawLine(9, 11, 11, 9);
            graphics.drawLine(10, 11, 11, 10);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        ResizeIcon() {
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            graphics.setColor(BasicGraphicsUtils.control);
            graphics.fill3DRect(n, n2, 13, 13, false);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.fill3DRect(n + 1, n2 + 1, 11, 11, false);
            if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                graphics.setColor(BasicGraphicsUtils.control);
            } else {
                graphics.setColor(BasicGraphicsUtils.controlWhite);
            }
            graphics.fillRect(n + 2, n2 + 2, 9, 9);
            if (buttonModel.isEnabled()) {
                graphics.setColor(BasicGraphicsUtils.controlBlack);
            } else {
                graphics.setColor(BasicGraphicsUtils.controlShadow);
            }
            if (buttonModel.isSelected()) {
                graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
                graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        CheckBoxIcon() {
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed() && buttonModel.isArmed() || !buttonModel.isEnabled()) {
                graphics.setColor(BasicGraphicsUtils.control);
            } else {
                graphics.setColor(BasicGraphicsUtils.controlWhite);
            }
            graphics.fillRect(n + 2, n2 + 2, 8, 8);
            graphics.setColor(BasicGraphicsUtils.controlShadow);
            graphics.drawLine(n + 4, n2, n + 7, n2);
            graphics.drawLine(n + 2, n2 + 1, n + 3, n2 + 1);
            graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 3);
            graphics.drawLine(n, n2 + 4, n, n2 + 7);
            graphics.drawLine(n + 1, n2 + 8, n + 1, n2 + 9);
            graphics.setColor(BasicGraphicsUtils.controlHighlight);
            graphics.drawLine(n + 2, n2 + 10, n + 3, n2 + 10);
            graphics.drawLine(n + 4, n2 + 11, n + 7, n2 + 11);
            graphics.drawLine(n + 8, n2 + 10, n + 9, n2 + 10);
            graphics.drawLine(n + 10, n2 + 9, n + 10, n2 + 8);
            graphics.drawLine(n + 11, n2 + 7, n + 11, n2 + 4);
            graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 2);
            graphics.setColor(BasicGraphicsUtils.controlBlack);
            graphics.drawLine(n + 4, n2 + 1, n + 7, n2 + 1);
            graphics.drawLine(n + 2, n2 + 2, n + 3, n2 + 2);
            graphics.drawLine(n + 8, n2 + 2, n + 9, n2 + 2);
            graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 7);
            graphics.drawLine(n + 2, n2 + 8, n + 2, n2 + 8);
            graphics.setColor(BasicGraphicsUtils.control);
            graphics.drawLine(n + 2, n2 + 9, n + 3, n2 + 9);
            graphics.drawLine(n + 4, n2 + 10, n + 7, n2 + 10);
            graphics.drawLine(n + 8, n2 + 9, n + 9, n2 + 9);
            graphics.drawLine(n + 9, n2 + 8, n + 9, n2 + 8);
            graphics.drawLine(n + 10, n2 + 7, n + 10, n2 + 4);
            graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
            if (buttonModel.isSelected()) {
                graphics.setColor(BasicGraphicsUtils.controlBlack);
                graphics.fillRect(n + 4, n2 + 5, 4, 2);
                graphics.fillRect(n + 5, n2 + 4, 2, 4);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        RadioButtonIcon() {
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isSelected();
            if (bl) {
                graphics.drawLine(n + 9, (n2 -= this.getIconHeight() / 2) + 3, n + 9, n2 + 3);
                graphics.drawLine(n + 8, n2 + 4, n + 9, n2 + 4);
                graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 8, n2 + 6);
                graphics.drawLine(n + 3, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 6, n2 + 8);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 6, n + 4, n2 + 6);
            }
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }

        CheckBoxMenuItemIcon() {
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillArc(0, 0, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 360);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }

        RadioButtonMenuItemIcon() {
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 9;
        }

        public int getIconHeight() {
            return 9;
        }

        MenuItemCheckIcon() {
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }

        MenuItemArrowIcon() {
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + this.getIconWidth(), n2 + this.getIconHeight() / 2);
            polygon.addPoint(n, n2 + this.getIconHeight());
            graphics.fillPolygon(polygon);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }

        MenuArrowIcon() {
        }
    }
}

