/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class ImageViewer
extends Component
implements Serializable {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected transient Image image = null;
    protected String fileName = null;
    protected URL url = null;
    protected int imageStyle = 1;
    protected transient ResourceBundle errors;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageViewer() {
    }

    public ImageViewer(String string) throws MalformedURLException {
        this();
        try {
            this.setFileName(string);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public ImageViewer(URL uRL) {
        this();
        try {
            this.setURL(uRL);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public ImageViewer(Image image) {
        this();
        try {
            this.setImage(image);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void setFileName(String string) throws PropertyVetoException {
        String string2 = this.fileName;
        try {
            this.vetos.fireVetoableChange("fileName", string2, string);
            this.fileName = string;
            if (this.fileName != null && this.fileName != "") {
                this.setURL(new URL(this.fileName));
            } else {
                this.setURL(null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.fileName = string2;
        }
        this.repaint();
        this.changes.firePropertyChange("fileName", string2, string);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setImageURL(URL uRL) throws PropertyVetoException {
        URL uRL2 = this.url;
        this.vetos.fireVetoableChange("imageURL", uRL2, uRL);
        this.url = uRL;
        this.fileName = null;
        Image image = null;
        if (this.url != null) {
            image = this.getToolkit().getImage(this.url);
        }
        this.setImage(image);
        this.repaint();
        this.changes.firePropertyChange("imageURL", uRL2, uRL);
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setURL(URL uRL) throws PropertyVetoException {
        this.setImageURL(uRL);
    }

    public URL getURL() {
        return this.getImageURL();
    }

    public void setCenterMode(boolean bl) throws PropertyVetoException {
        if (bl) {
            if (this.getStyle() != 1) {
                this.setStyle(1);
                return;
            }
        } else if (this.getStyle() != 3) {
            this.setStyle(3);
        }
    }

    public boolean getCenterMode() {
        return this.getStyle() == 1;
    }

    public void setStyle(int n) throws PropertyVetoException {
        if (n != this.imageStyle) {
            Integer n2 = new Integer(this.imageStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("style", n2, n3);
            this.imageStyle = n;
            this.repaint();
            this.changes.firePropertyChange("style", n2, n3);
        }
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public void setImage(Image image) throws PropertyVetoException {
        this.fileName = null;
        Image image2 = this.image;
        this.vetos.fireVetoableChange("image", image2, image);
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        this.image = image;
        if (image != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.image, 0);
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.repaint();
        }
        this.changes.firePropertyChange("image", image2, image);
    }

    public Image getImage() {
        return this.image;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.size();
        if (this.image != null) {
            int n = this.image.getWidth(this);
            int n2 = this.image.getHeight(this);
            switch (this.imageStyle) {
                default: {
                    graphics.drawImage(this.image, (dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2, this);
                    return;
                }
                case 0: {
                    int n3 = dimension.width / n;
                    if (dimension.width % n != 0) {
                        ++n3;
                    }
                    int n4 = dimension.height / n2;
                    if (dimension.height % n2 != 0) {
                        ++n4;
                    }
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n4) {
                        int n7 = 0;
                        int n8 = 0;
                        while (n8 < n3) {
                            graphics.drawImage(this.image, n7, n5, n, n2, this);
                            n7 += n;
                            ++n8;
                        }
                        n5 += n2;
                        ++n6;
                    }
                    return;
                }
                case 2: {
                    graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, this);
                    return;
                }
                case 3: 
            }
            graphics.drawImage(this.image, 0, 0, this);
            return;
        }
        graphics.clearRect(0, 0, dimension.width, dimension.height);
    }

    public Dimension preferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(10, 10);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.url != null) {
            this.image = this.getToolkit().getImage(this.url);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
                return;
            }
            catch (InterruptedException interruptedException) {
                Object[] objectArray = new Object[]{this.url};
                throw new IOException(MessageFormat.format(this.errors.getString("ErrorLoadingImageForURL"), objectArray));
            }
        }
    }
}

