/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kom.itbeankit.util.Convert;

public class ByteMap
implements Serializable,
Cloneable {
    public byte[][] theMap;
    public int width;
    public int height;

    public ByteMap(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.theMap = new byte[n][n2];
    }

    public void add(ByteMap byteMap) {
        if (byteMap.width != this.width || this.height != this.height) {
            return;
        }
        int n = 0;
        while (n < byteMap.height) {
            int n2 = 0;
            while (n2 < byteMap.width) {
                this.theMap[n2][n] = Convert.int2byte(Convert.byte2int(byteMap.theMap[n2][n]) + Convert.byte2int(this.theMap[n2][n]) & 0xFF);
                ++n2;
            }
            Thread.yield();
            ++n;
        }
    }

    public void add(ByteMap byteMap, int n, int n2) {
        if (byteMap == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < byteMap.height) {
            int n6 = 0;
            while (n6 < byteMap.width) {
                n3 = n + n6;
                n4 = n2 + n5;
                this.theMap[n3][n4] = Convert.int2byte(Convert.byte2int(byteMap.theMap[n6][n5]) + Convert.byte2int(this.theMap[n3][n4]) & 0xFF);
                ++n6;
            }
            ++n5;
        }
    }

    public void byte2map(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                this.theMap[n3][n2] = byArray[n++];
                ++n3;
            }
            ++n2;
        }
    }

    public Object clone() {
        ByteMap byteMap = new ByteMap(this.width, this.height);
        byteMap.copy(this, 0, this.width - 1, 0, this.height - 1, 0, 0);
        return byteMap;
    }

    public synchronized void copy(ByteMap byteMap, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3;
        while (n7 < byteMap.height && n7 <= n4) {
            int n8 = n;
            while (n8 < byteMap.width && n8 <= n2) {
                int n9 = n5 + n8 - n;
                int n10 = n6 + n7 - n3;
                if (n9 < this.width && n9 >= 0 && n10 < this.height && n10 >= 0) {
                    this.theMap[n5 + n8 - n][n6 + n7 - n3] = byteMap.theMap[n8][n7];
                }
                ++n8;
            }
            Thread.yield();
            ++n7;
        }
    }

    public ByteMap extend(int n, int n2) {
        int n3;
        ByteMap byteMap = new ByteMap(this.width * 2, this.height * 2);
        int n4 = 0;
        while (n4 < this.height) {
            n3 = 0;
            while (n3 < this.width) {
                byte by;
                byteMap.theMap[2 * n3][2 * n4] = by = this.theMap[n3][n4];
                byteMap.theMap[2 * n3][2 * n4 + 1] = by;
                byteMap.theMap[2 * n3 + 1][2 * n4] = by;
                byteMap.theMap[2 * n3 + 1][2 * n4 + 1] = by;
                ++n3;
            }
            Thread.yield();
            ++n4;
        }
        if (n > 0) {
            n = n / 2 * 2;
            ByteMap byteMap2 = (ByteMap)byteMap.clone();
            n3 = n;
            while (n3 < byteMap.height - n) {
                int n5 = n;
                while (n5 < byteMap.width - n) {
                    byteMap.interpolate(byteMap2, n5, n5 + n - 1, n3, n3 + n - 1, n2);
                    n5 += n;
                }
                Thread.yield();
                n3 += n;
            }
        }
        return byteMap;
    }

    public void fill(int n, int n2, int n3, int n4, byte by) {
        if (n <= this.width && n2 <= this.width && n3 <= this.height && n4 <= this.height) {
            ++n4;
            ++n2;
            int n5 = n3;
            while (n5 < n4) {
                int n6 = n;
                while (n6 < n2) {
                    this.theMap[n6][n5] = by;
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public void interpolate(ByteMap byteMap, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n2) {
                this.theMap[n7][n6] = Convert.int2byte(Math.round((float)byteMap.theMap[n7][n6] * ((float)(100 - n5) / 100.0f) + ((float)byteMap.theMap[n - 1][n6] + ((float)(n7 - n) + 1.0f) / ((float)(n2 - n) + 2.0f) * (float)(byteMap.theMap[n2 + 1][n6] - byteMap.theMap[n - 1][n6])) * ((float)n5 / 200.0f) + ((float)byteMap.theMap[n7][n3 - 1] + ((float)(n6 - n3) + 1.0f) / ((float)(n4 - n3) + 2.0f) * (float)(byteMap.theMap[n7][n4 + 1] - byteMap.theMap[n7][n3 - 1])) * ((float)n5 / 200.0f)));
                ++n7;
            }
            Thread.yield();
            ++n6;
        }
    }

    public byte[] map2byte() {
        byte[] byArray = new byte[this.width * this.height];
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                byArray[n++] = this.theMap[n3][n2];
                ++n3;
            }
            ++n2;
        }
        return byArray;
    }

    public void medium(ByteMap byteMap) {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.theMap[n2][n] = Convert.int2byte(Convert.byte2int(this.theMap[n2][n]) + Convert.byte2int(byteMap.theMap[n2][n]) >>> 1);
                ++n2;
            }
            ++n;
        }
    }

    public void negate() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                byte[] byArray = this.theMap[n2];
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] ^ 0xFF);
                byte[] byArray2 = this.theMap[n2];
                int n4 = n;
                byArray2[n4] = (byte)(byArray2[n4] + 1);
                ++n2;
            }
            Thread.yield();
            ++n;
        }
    }

    public void read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.width * this.height];
        inputStream.read(byArray, 0, this.width * this.height);
        this.byte2map(byArray);
    }

    public ByteMap reduce(int n) {
        int n2 = 0;
        int n3 = 0;
        if ((n = n / 2 * 2) > 0) {
            ByteMap byteMap = new ByteMap(this.width / 2, this.height / 2);
            int n4 = 0;
            while (n4 < this.height) {
                int n5 = 0;
                while (n5 < this.width) {
                    int n6 = 0;
                    int n7 = 0;
                    n3 = n4;
                    while (n3 < this.height & n3 < n4 + n) {
                        n2 = n5;
                        while (n2 < this.width & n2 < n5 + n) {
                            n6 += Convert.byte2int(this.theMap[n2][n3]);
                            ++n7;
                            ++n2;
                        }
                        ++n3;
                    }
                    byte by = Convert.int2byte(n6 / n7);
                    byteMap.fill(n5 / 2, n2 / 2 - 1, n4 / 2, n3 / 2 - 1, by);
                    n5 += n;
                }
                Thread.yield();
                n4 += n;
            }
            return byteMap;
        }
        return this;
    }

    public void resize(int n, int n2) {
        if (this.width < n || this.height < n2) {
            return;
        }
        ByteMap byteMap = new ByteMap(n, n2);
        float f = (float)this.width / (float)n;
        float f2 = (float)this.height / (float)n2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = Math.round((float)n4 * f);
                int n6 = Math.round((float)n3 * f2);
                byteMap.theMap[n4][n3] = this.theMap[n5][n6];
                ++n4;
            }
            Thread.yield();
            ++n3;
        }
        this.theMap = byteMap.theMap;
        this.width = byteMap.width;
        this.height = byteMap.height;
    }

    public ByteMap sub(ByteMap byteMap, ByteMap byteMap2) {
        if (byteMap.width != byteMap2.width | byteMap.height != byteMap2.height) {
            return null;
        }
        ByteMap byteMap3 = new ByteMap(byteMap.width, byteMap.height);
        int n = 0;
        while (n < byteMap.height) {
            int n2 = 0;
            while (n2 < byteMap.width) {
                byteMap3.theMap[n2][n] = (byte)(byteMap.theMap[n2][n] - byteMap2.theMap[n2][n]);
                ++n2;
            }
            ++n;
        }
        return byteMap3;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.map2byte());
    }
}

