/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.mva.model;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kom.itbeankit.mm.compression.mva.model.MVAFilenameFilter;
import kom.itbeankit.mm.compression.mva.model.MacroBlock;
import kom.itbeankit.mm.compression.mva.model.YUVByteMap;

public class MacroBlockMatrix
implements Cloneable,
Serializable {
    public int xNumber;
    public int yNumber;
    public MacroBlock[][] mbm;

    public MacroBlockMatrix(int n, int n2) {
        this.xNumber = n;
        this.yNumber = n2;
        this.mbm = new MacroBlock[n][n2];
        int n3 = 0;
        while (n3 < this.yNumber) {
            int n4 = 0;
            while (n4 < this.xNumber) {
                this.mbm[n4][n3] = new MacroBlock();
                ++n4;
            }
            ++n3;
        }
    }

    public Object clone() {
        MacroBlockMatrix macroBlockMatrix = new MacroBlockMatrix(this.xNumber, this.yNumber);
        int n = 0;
        while (n < this.yNumber) {
            int n2 = 0;
            while (n2 < this.xNumber) {
                macroBlockMatrix.mbm[n2][n] = (MacroBlock)this.mbm[n2][n].clone();
                ++n2;
            }
            ++n;
        }
        return macroBlockMatrix;
    }

    public YUVByteMap mbm2yuv() {
        YUVByteMap yUVByteMap = new YUVByteMap(this.mbm[0][0].width * this.xNumber, this.mbm[0][0].height * this.yNumber, 2);
        int n = 0;
        while (n < this.yNumber) {
            int n2 = 0;
            while (n2 < this.xNumber) {
                yUVByteMap.copyYUV(this.mbm[n2][n], n2 * this.mbm[n2][n].width, n * this.mbm[n2][n].height);
                ++n2;
            }
            ++n;
        }
        return yUVByteMap;
    }

    public void negate() {
        int n = 0;
        while (n < this.yNumber) {
            int n2 = 0;
            while (n2 < this.xNumber) {
                this.mbm[n2][n].negate();
                ++n2;
            }
            Thread.yield();
            ++n;
        }
    }

    public void read(InputStream inputStream) throws IOException {
        int n = 0;
        while (n < this.yNumber) {
            int n2 = 0;
            while (n2 < this.xNumber) {
                this.mbm[n2][n].read(inputStream);
                ++n2;
            }
            ++n;
        }
    }

    public static MacroBlockMatrix readMBM(InputStream inputStream) throws IOException {
        int n = inputStream.available();
        long l = n;
        Dimension dimension = MVAFilenameFilter.getDimension(l, 150);
        if (dimension == null) {
            throw new IOException("Input has unknown dimension");
        }
        MacroBlockMatrix macroBlockMatrix = new MacroBlockMatrix(dimension.width / 16, dimension.height / 16);
        macroBlockMatrix.read(inputStream);
        inputStream.close();
        return macroBlockMatrix;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n < this.yNumber) {
            int n2 = 0;
            while (n2 < this.xNumber) {
                this.mbm[n2][n].write(outputStream);
                ++n2;
            }
            ++n;
        }
    }
}

