/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class Line
extends Component {
    protected boolean slopeType = false;
    protected int lineThickness = 1;
    protected Polygon poly;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public boolean contains(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (!super.contains(n, n2)) {
            return false;
        }
        if (this.lineThickness > 1) {
            if (this.poly != null) {
                return this.poly.contains(n, n2);
            }
            return false;
        }
        Dimension dimension = this.getSize();
        if (this.slopeType) {
            d4 = dimension.width;
            d3 = 0.0;
            d2 = 0.0;
            d = dimension.height;
        } else {
            d4 = dimension.width;
            d3 = dimension.height;
            d2 = 0.0;
            d = 0.0;
        }
        if (dimension.width > dimension.height) {
            double d5 = Math.abs((d3 - d) * ((double)n - d2) / (d4 - d2) + d);
            return Math.abs((double)n2 - d5) < 0.7000000000000001;
        }
        double d6 = Math.abs((d4 - d2) * ((double)n2 - d) / (d3 - d) + d2);
        return Math.abs((double)n - d6) < 0.7000000000000001;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public boolean isPositiveSlope() {
        return this.slopeType;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        if (this.slopeType) {
            n4 = dimension.width;
            n3 = 0;
            n2 = 0;
            n = dimension.height;
        } else {
            n4 = dimension.width;
            n3 = dimension.height;
            n2 = 0;
            n = 0;
        }
        graphics.setColor(this.getForeground());
        if (this.lineThickness > 1) {
            int n5;
            int n6;
            int n7;
            int n8;
            double d = this.lineThickness / 2;
            double d2 = 3.1416 - (1.5708 + Math.abs(Math.atan((double)(n3 - n) / (double)(n4 - n2))));
            double d3 = Math.abs(d * Math.cos(d2));
            double d4 = Math.abs(d * Math.sin(d2));
            if (this.slopeType) {
                n8 = (int)((double)n4 - d3 - d3);
                n7 = (int)((double)n3 + d4 + d4);
                n6 = (int)((double)n2 + d3 + d3);
                n5 = (int)((double)n - d4 - d4);
            } else {
                n8 = (int)((double)n4 - d3 - d3);
                n7 = (int)((double)n3 - d4 - d4);
                n6 = (int)((double)n2 + d3 + d3);
                n5 = (int)((double)n + d4 + d4);
            }
            this.poly = new Polygon();
            this.poly.addPoint(n8, n3);
            this.poly.addPoint(n4, n7);
            this.poly.addPoint(n6, n);
            this.poly.addPoint(n2, n5);
            graphics.fillPolygon(this.poly);
            return;
        }
        graphics.drawLine(n4, n3, n2, n);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setLineThickness(int n) throws PropertyVetoException {
        if (this.lineThickness != n) {
            Integer n2 = new Integer(this.lineThickness);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("LineThickness", n2, n3);
            this.lineThickness = n;
            this.repaint();
            this.changes.firePropertyChange("LineThickness", n2, n3);
        }
    }

    public void setPositiveSlope(boolean bl) throws PropertyVetoException {
        if (this.slopeType != bl) {
            Boolean bl2 = new Boolean(this.slopeType);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("PositiveSlope", bl2, bl3);
            this.slopeType = bl;
            this.repaint();
            this.changes.firePropertyChange("PositiveSlope", bl2, bl3);
        }
    }
}

