/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public abstract class Shape
extends Component
implements BevelStyle {
    protected int width;
    protected int height;
    protected int style = 2;
    protected boolean fill;
    protected Color fillColor = Color.black;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color cachedBackground;
    protected VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected Shape() {
        this.cachedBackground = this.getBackground();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public int getBevelStyle() {
        return this.style;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public boolean getFillMode() {
        return this.isFillMode();
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public boolean isFillMode() {
        return this.fill;
    }

    public synchronized void paint(Graphics graphics) {
        Color color = this.getBackground();
        if (!GeneralUtils.objectsEqual(color, this.cachedBackground)) {
            this.cachedBackground = color;
            this.updateBevelColors(color);
        }
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        super.reshape(n, n2, n3, n4);
    }

    public void setBevelStyle(int n) throws PropertyVetoException {
        if (this.style != n) {
            Integer n2 = new Integer(this.style);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("BevelStyle", n2, n3);
            this.style = n;
            this.repaint();
            this.changes.firePropertyChange("BevelStyle", n2, n3);
        }
    }

    public void setFillColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.fillColor, color)) {
            Boolean bl = new Boolean(this.fill);
            this.vetos.fireVetoableChange("FillColor", bl, color);
            this.fillColor = color;
            this.repaint();
            this.changes.firePropertyChange("FillColor", bl, color);
        }
    }

    public void setFillMode(boolean bl) throws PropertyVetoException {
        if (this.fill != bl) {
            Boolean bl2 = new Boolean(this.fill);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("FillMode", bl2, bl3);
            this.fill = bl;
            this.repaint();
            this.changes.firePropertyChange("FillMode", bl2, bl3);
        }
    }

    protected void updateBevelColors(Color color) {
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(color);
        this.bevelLighterColor = ColorUtils.calculateHilightColor(color);
    }
}

