/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.nw.ethernet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import kom.itbeankit.common.message.MessageEvent;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.nw.ethernet.AlgorithmInterface;
import kom.itbeankit.nw.ethernet.DataEvent;
import kom.itbeankit.nw.ethernet.DataListener;
import kom.itbeankit.nw.ethernet.EthernetInterface;
import kom.itbeankit.nw.ethernet.Host;
import kom.itbeankit.nw.ethernet.Switch;
import kom.itbeankit.nw.ethernet.Switchap;
import kom.itbeankit.nw.ethernet.Table;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.VerticalSlider;

public class Switchap
extends Container
implements EthernetInterface,
ClkListener,
MessageListener {
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected boolean iamenabled = false;
    protected int numOfHosts = 6;
    private Vector messageListeners = new Vector();
    protected int scenario = 0;
    Panel switchapPanel = new Panel();
    Panel hostTopPanel;
    Host host3;
    Host host5;
    Panel busPanel;
    Switch switch1;
    Switch switch2;
    Panel hostBottomPanel;
    Host host2;
    Host host4;
    Host host6;
    Host host1;
    BorderPanel efficiencyPanel;
    VerticalSlider performanceSlider;
    Label maxLabel;
    Label minLabel;
    Button helpButton;
    Table table1;
    Table table2;
    Label label1;
    Label label2;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.host1.setEnabled(b);
        this.host2.setEnabled(b);
        this.host3.setEnabled(b);
        this.host4.setEnabled(b);
        this.host5.setEnabled(b);
        this.host6.setEnabled(b);
        this.iamenabled = b;
    }

    public void doScenario(ClkEvent e) {
        switch (this.scenario) {
            case 0: {
                this.scenarioNone(e);
                break;
            }
            case 1: {
                this.scenarioNormal(e);
                break;
            }
            case 2: {
                this.scenarioNormal2(e);
                break;
            }
            case 3: {
                this.scenarioCollision(e);
                break;
            }
        }
    }

    void scenarioNone(ClkEvent e) {
        if (e.isRisingEdge()) {
            this.showEfficiency();
        }
        this.switch1.clkReceived(e);
        this.host1.clkReceived(e);
        this.host2.clkReceived(e);
        this.host3.clkReceived(e);
        if (this.numOfHosts > 3) {
            this.host4.clkReceived(e);
            this.host5.clkReceived(e);
            this.host6.clkReceived(e);
            this.switch2.clkReceived(e);
        }
        if (this.iamenabled) {
            int destH = 0;
            if (this.host1.getIDE() != 0) {
                this.table1.Data_in("1", "1");
                this.table2.Data_in("1", "1");
                destH = this.host1.getDestinationHost();
                this.setHostPort(1, destH, 1);
                this.setHostPort(1, destH, 2);
                this.host1.setIDE(0);
            }
            if (this.host2.getIDE() != 0) {
                this.table1.Data_in("2", "3");
                this.table2.Data_in("2", "1");
                destH = this.host2.getDestinationHost();
                this.setHostPort(2, destH, 1);
                this.setHostPort(2, destH, 2);
                this.host2.setIDE(0);
            }
            if (this.host3.getIDE() != 0) {
                this.table1.Data_in("3", "2");
                this.table2.Data_in("3", "1");
                destH = this.host3.getDestinationHost();
                this.setHostPort(3, destH, 1);
                this.setHostPort(3, destH, 2);
                this.host3.setIDE(0);
            }
            if (this.host4.getIDE() != 0) {
                this.table1.Data_in("4", "4");
                this.table2.Data_in("4", "3");
                destH = this.host4.getDestinationHost();
                this.setHostPort(4, destH, 1);
                this.setHostPort(4, destH, 2);
                this.host4.setIDE(0);
            }
            if (this.host5.getIDE() != 0) {
                this.table1.Data_in("5", "4");
                this.table2.Data_in("5", "2");
                destH = this.host5.getDestinationHost();
                this.setHostPort(5, destH, 1);
                this.setHostPort(5, destH, 2);
                this.host5.setIDE(0);
            }
            if (this.host6.getIDE() != 0) {
                this.table1.Data_in("6", "4");
                this.table2.Data_in("6", "4");
                destH = this.host6.getDestinationHost();
                this.setHostPort(6, destH, 1);
                this.setHostPort(6, destH, 2);
                this.host6.setIDE(0);
            }
        }
    }

    void scenarioNormal(ClkEvent e) {
        if (this.numOfHosts == 3) {
            this.msg("scenario  operation", "\n  in this scenario host3 sends\n   a frame to host1.If we had had\na cable instead of a switch that would\nhave not worked because an\nEthernet cable needs all its ways \nout closed with a Host or with 50 ohm");
            this.host3.setFrameSize(56);
            this.host3.setAutoRepeat(false);
            this.setHostPort(3, 1, 1);
            this.setHostPort(3, 1, 2);
            this.host3.setDestinationHost(1);
            this.table2.Data_in("3", "1");
            this.table1.Data_in("3", "2");
            this.scenario = 0;
        } else if (this.numOfHosts == 6) {
            this.msg("scenario normal operation", "\n  in this scenario host5 sends\n   a frame to host2");
            this.host5.setFrameSize(56);
            this.host5.setAutoRepeat(false);
            this.setHostPort(5, 2, 2);
            this.setHostPort(5, 2, 1);
            this.host5.setDestinationHost(2);
            this.table2.Data_in("5", "2");
            this.table1.Data_in("5", "4");
            this.scenario = 0;
        }
    }

    void scenarioNormal2(ClkEvent e) {
        System.out.println("Endlich");
        if (this.numOfHosts == 3) {
            this.msg("scenario normal operation", "\n  in this scenario host1 sends\n   a frame to host3.If we had had\na cable instead of a switch that would\nhave not worked because an\nEthernet cable needs all its ways \nout closed with a Host or with 50 ohm");
            this.host1.setFrameSize(56);
            this.host1.setAutoRepeat(false);
            this.setHostPort(1, 3, 1);
            this.setHostPort(1, 3, 2);
            this.host1.setDestinationHost(3);
            this.table2.Data_in("1", "1");
            this.table1.Data_in("1", "1");
            this.scenario = 0;
        } else if (this.numOfHosts == 6) {
            this.msg("scenario normal operation", "\n  in this scenario host1 sends\n   a frame to host5");
            this.host1.setFrameSize(56);
            this.host1.setAutoRepeat(false);
            this.setHostPort(1, 5, 2);
            this.setHostPort(1, 5, 1);
            this.host1.setDestinationHost(5);
            this.table2.Data_in("1", "1");
            this.table1.Data_in("1", "1");
            this.scenario = 0;
        }
    }

    void scenarioCollision(ClkEvent e) {
        if (this.numOfHosts == 3) {
            this.msg("scenario collision", "\n   in this scenario host2 and\n   host3 send frames at the same\n   time to host3 and host1");
            this.host3.setFrameSize(56);
            this.host3.setAutoRepeat(false);
            this.host2.setFrameSize(56);
            this.host2.setAutoRepeat(false);
            this.setHostPort(2, 3, 1);
            this.setHostPort(2, 3, 2);
            this.host2.setDestinationHost(3);
            this.table2.Data_in("2", "1");
            this.table1.Data_in("2", "3");
            this.setHostPort(3, 1, 1);
            this.setHostPort(3, 1, 2);
            this.host3.setDestinationHost(1);
            this.table2.Data_in("3", "1");
            this.table1.Data_in("3", "2");
            this.scenario = 0;
        } else if (this.numOfHosts == 6) {
            this.msg("scenario collision", "\n   in this scenario host2 and\n   host6 send frames at the same\n   time to host5 and host1");
            this.host6.setFrameSize(56);
            this.host6.setAutoRepeat(false);
            this.host2.setFrameSize(56);
            this.host2.setAutoRepeat(false);
            String destiPort = "";
            int destP = 0;
            destiPort = this.table1.Search_DestPort(String.valueOf(5));
            double dp = new Double(destiPort);
            destP = (int)dp;
            if (destP != 0) {
                System.out.println("tengo informcion del host5");
                this.switch1.setUnten(4);
                this.switch2.setLinks(2);
            } else {
                this.switch1.setUnten(0);
                this.switch2.setLinks(0);
            }
            this.host2.setDestinationHost(5);
            this.table2.Data_in("2", "1");
            this.table1.Data_in("2", "3");
            destiPort = this.table1.Search_DestPort(String.valueOf(1));
            double dp1 = new Double(destiPort);
            destP = (int)dp1;
            if (destP != 0) {
                System.out.println("tengo informcion del host1");
                this.switch1.setRechts(1);
                this.switch2.setRechts(1);
            } else {
                this.switch1.setRechts(0);
                this.switch2.setRechts(0);
            }
            this.host6.setDestinationHost(1);
            this.table2.Data_in("6", "4");
            this.table1.Data_in("6", "4");
            this.scenario = 0;
        }
    }

    public void setScenario(int scenario) {
        this.scenario = scenario;
    }

    public int getScenario() {
        return this.scenario;
    }

    void msg(String subject, String message) {
        this.deliverMessage(new MessageEvent(this, 701, 710, subject, message));
    }

    public void deliverMessage(MessageEvent me) {
        MessageEvent event = new MessageEvent(this, me);
        int i = 0;
        while (i < this.messageListeners.size()) {
            MessageListener ml = (MessageListener)this.messageListeners.elementAt(i);
            ml.deliverMessage(event);
            ++i;
        }
    }

    public synchronized void addMessageListener(MessageListener lis) {
        this.messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis) {
        this.messageListeners.removeElement(lis);
    }

    public void setNumOfHosts(int num) {
        switch (num) {
            case 3: {
                this.numOfHosts = 3;
                this.set2ndPairVisible(false);
                break;
            }
            case 6: {
                this.numOfHosts = 6;
                this.set2ndPairVisible(true);
                break;
            }
        }
    }

    void set2ndPairVisible(boolean b) {
        this.host4.setVisible(b);
        this.host5.setVisible(b);
        this.host6.setVisible(b);
        this.switch2.setVisible(b);
        if (!b) {
            this.host4.reset();
            this.host5.reset();
            this.host6.reset();
            this.switch2.reset();
        }
    }

    public int getNumOfHosts() {
        return this.numOfHosts;
    }

    public void setAlgorithm(String algorithmName) {
        this.algorithm = this.algorithm;
        this.host1.setAlgorithm(algorithmName);
        this.host2.setAlgorithm(algorithmName);
        this.host3.setAlgorithm(algorithmName);
        this.host4.setAlgorithm(algorithmName);
        this.host5.setAlgorithm(algorithmName);
        this.host6.setAlgorithm(algorithmName);
    }

    public AlgorithmInterface getAlgorithm() {
        return this.algorithm;
    }

    public void setUsePadField(boolean usePadField) {
        this.usePadField = usePadField;
        this.host1.setUsePadField(usePadField);
        this.host2.setUsePadField(usePadField);
        this.host3.setUsePadField(usePadField);
        this.host4.setUsePadField(usePadField);
        this.host5.setUsePadField(usePadField);
        this.host6.setUsePadField(usePadField);
    }

    public boolean isUsePadField() {
        return this.usePadField;
    }

    public Switchap() {
        this.switchapPanel.setLayout(null);
        this.switchapPanel.setBounds(0, 0, 425, 252);
        this.add(this.switchapPanel);
        this.hostTopPanel = new Panel();
        this.hostTopPanel.setLayout(null);
        this.hostTopPanel.setBounds(10, 10, 400, 74);
        this.switchapPanel.add(this.hostTopPanel);
        this.host3 = new Host();
        this.host3.setID(3);
        this.host3.setBounds(98, 0, 80, 74);
        this.hostTopPanel.add(this.host3);
        this.host3.setCursor(new Cursor(12));
        this.host5 = new Host();
        this.host5.setID(5);
        this.host5.setBounds(230, 0, 80, 74);
        this.hostTopPanel.add(this.host5);
        this.host5.setCursor(new Cursor(12));
        this.busPanel = new Panel();
        this.busPanel.setLayout(null);
        this.busPanel.setBounds(80, 84, 260, 76);
        this.switchapPanel.add(this.busPanel);
        this.switch1 = new Switch();
        this.switch1.setSwitchLabel("");
        this.switch1.setLayout(new BorderLayout(0, 0));
        this.switch1.setBounds(0, 0, 130, 76);
        this.busPanel.add(this.switch1);
        this.switch2 = new Switch();
        this.switch2.setSwitchLabel("");
        this.switch2.setLayout(new BorderLayout(0, 0));
        this.switch2.setBounds(130, 0, 130, 76);
        this.busPanel.add(this.switch2);
        this.hostBottomPanel = new Panel();
        this.hostBottomPanel.setLayout(null);
        this.hostBottomPanel.setBounds(10, 160, 400, 80);
        this.switchapPanel.add(this.hostBottomPanel);
        this.host2 = new Host();
        this.host2.setOverTheBus(false);
        this.host2.setID(2);
        this.host2.setBounds(92, 0, 80, 74);
        this.hostBottomPanel.add(this.host2);
        this.host2.setCursor(new Cursor(12));
        this.host4 = new Host();
        this.host4.setOverTheBus(false);
        this.host4.setID(4);
        this.host4.setBounds(224, 0, 80, 74);
        this.hostBottomPanel.add(this.host4);
        this.host4.setCursor(new Cursor(12));
        this.host6 = new Host();
        this.host6.setOverTheBus(false);
        this.host6.setID(6);
        this.host6.setBounds(336, 56, 80, 74);
        this.switchapPanel.add(this.host6);
        this.host6.setCursor(new Cursor(12));
        this.host1 = new Host();
        this.host1.setBounds(0, 76, 80, 74);
        this.switchapPanel.add(this.host1);
        this.host1.setCursor(new Cursor(12));
        this.efficiencyPanel = new BorderPanel();
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.efficiencyPanel.setLayout(gridBagLayout);
        this.efficiencyPanel.setBounds(432, 0, 80, 252);
        this.add(this.efficiencyPanel);
        this.performanceSlider = new VerticalSlider();
        try {
            this.performanceSlider.setMaxValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setMinValue(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickFreq(10);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.performanceSlider.setTickStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.performanceSlider.setBounds(5, 0, 20, 208);
        this.performanceSlider.setBackground(new Color(0xC0C0C0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, -20, 0);
        gbc.ipadx = 12;
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.performanceSlider, gbc);
        this.efficiencyPanel.add(this.performanceSlider);
        this.performanceSlider.setEnabled(false);
        this.maxLabel = new Label("100%", 2);
        this.maxLabel.setBounds(25, 0, 34, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.maxLabel, gbc);
        this.efficiencyPanel.add(this.maxLabel);
        this.minLabel = new Label("0%", 2);
        this.minLabel.setBounds(35, 188, 24, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.minLabel, gbc);
        this.efficiencyPanel.add(this.minLabel);
        this.helpButton = new Button();
        this.helpButton.setLabel("?");
        this.helpButton.setBounds(36, 94, 21, 23);
        this.helpButton.setFont(new Font("Dialog", 1, 12));
        this.helpButton.setForeground(new Color(255));
        this.helpButton.setBackground(new Color(0xC0C0C0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        ((GridBagLayout)this.efficiencyPanel.getLayout()).setConstraints(this.helpButton, gbc);
        this.efficiencyPanel.add(this.helpButton);
        this.helpButton.setCursor(new Cursor(12));
        this.table1 = new Table();
        this.table1.setLayout(null);
        this.table1.setBounds(520, 36, 96, 210);
        this.table1.setForeground(new Color(0x404040));
        this.table1.setBackground(new Color(0xFFFFFF));
        this.add(this.table1);
        this.table2 = new Table();
        this.table2.setLayout(null);
        this.table2.setBounds(618, 36, 96, 210);
        this.table2.setForeground(new Color(0x404040));
        this.table2.setBackground(new Color(0xFFFFFF));
        this.add(this.table2);
        this.label1 = new Label("Switch1", 1);
        this.label1.setBounds(520, 0, 94, 30);
        this.label1.setFont(new Font("Dialog", 0, 12));
        this.add(this.label1);
        this.label2 = new Label("Switch2", 1);
        this.label2.setBounds(620, 0, 94, 30);
        this.label2.setFont(new Font("Dialog", 0, 12));
        this.add(this.label2);
        this.switch1.setSwitchLabel("Switch1");
        this.switch2.setSwitchLabel("Switch2");
        this.validate();
        try {
            this.efficiencyPanel.setLabel("Efficiency");
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        this.setNumOfHosts(6);
        SymData lSymData = new SymData();
        this.host1.addDataListener(lSymData);
        this.host2.addDataListener(lSymData);
        this.host3.addDataListener(lSymData);
        this.host5.addDataListener(lSymData);
        this.host4.addDataListener(lSymData);
        this.host6.addDataListener(lSymData);
        SymMessage lSymMessage = new SymMessage();
        this.host1.addMessageListener(lSymMessage);
        this.host2.addMessageListener(lSymMessage);
        this.host3.addMessageListener(lSymMessage);
        this.host4.addMessageListener(lSymMessage);
        this.host5.addMessageListener(lSymMessage);
        this.host6.addMessageListener(lSymMessage);
        SymAction lSymAction = new SymAction();
        this.helpButton.addActionListener(lSymAction);
        this.switch1.addDataListener(lSymData);
        this.switch2.addDataListener(lSymData);
    }

    public void clkReceived(ClkEvent e) {
        this.doScenario(e);
    }

    public void reset() {
        this.switch1.reset();
        this.switch2.reset();
        this.host1.reset();
        this.host2.reset();
        this.host3.reset();
        this.host4.reset();
        this.host5.reset();
        this.host6.reset();
        this.clkReceived(new ClkEvent(this, true));
        this.clkReceived(new ClkEvent(this, false));
        this.clkReceived(new ClkEvent(this, true));
    }

    public void resetDataSize() {
        try {
            this.performanceSlider.setValue(100);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.host1.resetDataSize();
        this.host2.resetDataSize();
        this.host3.resetDataSize();
        this.host4.resetDataSize();
        this.host5.resetDataSize();
        this.host6.resetDataSize();
    }

    public int getEfficiency() {
        double sentDataSize = 0.0;
        double receivedDataSize = 0.0;
        sentDataSize = this.host1.getSentDataSize() + this.host2.getSentDataSize() + this.host3.getSentDataSize() + this.host4.getSentDataSize() + this.host5.getSentDataSize() + this.host6.getSentDataSize();
        receivedDataSize = this.host1.getReceivedDataSize() + this.host2.getReceivedDataSize() + this.host3.getReceivedDataSize() + this.host4.getReceivedDataSize() + this.host5.getReceivedDataSize() + this.host6.getReceivedDataSize();
        double returnValue = -1.0;
        if (sentDataSize != 0.0) {
            returnValue = receivedDataSize / sentDataSize * 100.0;
        }
        return (int)returnValue;
    }

    void showEfficiency() {
        block2: {
            int eff = this.getEfficiency();
            if (eff == -1) break block2;
            try {
                this.performanceSlider.setValue(100 - eff);
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        new 1.DriverFrame().show();
    }

    void host_deliverMessage(MessageEvent event) {
        this.deliverMessage(event);
    }

    void helpButton_ActionPerformed(ActionEvent event) {
        this.deliverMessage(new MessageEvent(this, 702, 710, "Efficiency", " Shows the proportion of received data to the sent data by all hosts."));
    }

    void host2_dataToTop(DataEvent event) {
        this.switch1.dataFromBottom(event);
    }

    void host4_dataToTop(DataEvent event) {
        this.switch2.dataFromBottom(event);
    }

    void host6_dataToTop(DataEvent event) {
        this.switch2.dataFromRight(event);
    }

    void host2_dataToBottom(DataEvent event) {
        this.switch1.dataFromBottom(event);
    }

    void host3_dataToBottom(DataEvent event) {
        this.switch1.dataFromTop(event);
    }

    void host5_dataToBottom(DataEvent event) {
        this.switch2.dataFromTop(event);
    }

    void host6_dataToBottom(DataEvent event) {
        this.switch2.dataFromRight(event);
    }

    void host1_dataToBottom(DataEvent event) {
        this.switch1.dataFromLeft(event);
    }

    void host4_dataToBottom(DataEvent event) {
        this.switch2.dataFromBottom(event);
    }

    void switch1_dataToRight(DataEvent event) {
        this.switch2.dataFromLeft(event);
    }

    void switch2_dataToLeft(DataEvent event) {
        this.switch1.dataFromRight(event);
    }

    void switch1_dataToLeft(DataEvent event) {
        this.host1.dataFromTop(event);
    }

    void switch2_dataToRight(DataEvent event) {
        this.host6.dataFromTop(event);
    }

    void switch1_dataToTop(DataEvent event) {
        this.host3.dataFromTop(event);
    }

    void switch2_dataToTop(DataEvent event) {
        this.host5.dataFromTop(event);
    }

    void switch1_dataToBottom(DataEvent event) {
        this.host2.dataFromTop(event);
    }

    void switch2_dataToBottom(DataEvent event) {
        this.host4.dataFromTop(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHostPort(int sourceHost, int destHost, int numSwitch) {
        String destiPort = "";
        int destP = 0;
        boolean oben = false;
        boolean unten = false;
        boolean links = false;
        boolean rechts = false;
        if (numSwitch == 1) {
            destiPort = this.table1.Search_DestPort(String.valueOf(destHost));
            double dp = new Double(destiPort);
            destP = (int)dp;
            if (destP != 0) {
                System.out.println("switch1,activado" + destP);
            }
            switch (sourceHost) {
                case 1: {
                    this.switch1.setLinks(destP);
                    return;
                }
                case 2: {
                    this.switch1.setUnten(destP);
                    return;
                }
                case 3: {
                    this.switch1.setOben(destP);
                    return;
                }
                case 4: {
                    this.switch1.setRechts(destP);
                    return;
                }
                case 5: {
                    this.switch1.setRechts(destP);
                    return;
                }
                case 6: {
                    this.switch1.setRechts(destP);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        destiPort = this.table2.Search_DestPort(String.valueOf(destHost));
        double dp = new Double(destiPort);
        destP = (int)dp;
        if (destP != 0) {
            System.out.println("switch2,activado" + destP);
        }
        switch (sourceHost) {
            case 1: {
                this.switch2.setLinks(destP);
                break;
            }
            case 2: {
                this.switch2.setLinks(destP);
                break;
            }
            case 3: {
                this.switch2.setLinks(destP);
                break;
            }
            case 4: {
                this.switch2.setUnten(destP);
                break;
            }
            case 5: {
                this.switch2.setOben(destP);
                break;
            }
            case 6: {
                this.switch2.setRechts(destP);
            }
        }
    }

    class SymMessage
    implements MessageListener {
        public void deliverMessage(MessageEvent event) {
            Switchap.this.host_deliverMessage(event);
        }

        SymMessage() {
            Switchap.this = Switchap.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == Switchap.this.helpButton) {
                Switchap.this.helpButton_ActionPerformed(event);
            }
        }

        SymAction() {
            Switchap.this = Switchap.this;
        }
    }

    class SymData
    implements DataListener {
        public void dataToRight(DataEvent event) {
            Object object = event.getSource();
            if (object == Switchap.this.switch1) {
                Switchap.this.switch1_dataToRight(event);
            } else if (object == Switchap.this.switch2) {
                Switchap.this.switch2_dataToRight(event);
            }
        }

        public void dataToTop(DataEvent event) {
            Object object = event.getSource();
            if (object == Switchap.this.switch1) {
                Switchap.this.switch1_dataToTop(event);
            } else if (object == Switchap.this.switch2) {
                Switchap.this.switch2_dataToTop(event);
            } else if (object == Switchap.this.host2) {
                Switchap.this.host2_dataToTop(event);
            } else if (object == Switchap.this.host4) {
                Switchap.this.host4_dataToTop(event);
            } else if (object == Switchap.this.host6) {
                Switchap.this.host6_dataToTop(event);
            }
        }

        public void dataToBottom(DataEvent event) {
            Object object = event.getSource();
            if (object == Switchap.this.host3) {
                Switchap.this.host3_dataToBottom(event);
            } else if (object == Switchap.this.host5) {
                Switchap.this.host5_dataToBottom(event);
            } else if (object == Switchap.this.host1) {
                Switchap.this.host1_dataToBottom(event);
            } else if (object == Switchap.this.switch1) {
                Switchap.this.switch1_dataToBottom(event);
            } else if (object == Switchap.this.switch2) {
                Switchap.this.switch2_dataToBottom(event);
            }
        }

        public void dataToLeft(DataEvent event) {
            Object object = event.getSource();
            if (object == Switchap.this.switch2) {
                Switchap.this.switch2_dataToLeft(event);
            } else if (object == Switchap.this.switch1) {
                Switchap.this.switch1_dataToLeft(event);
            }
        }

        SymData() {
            Switchap.this = Switchap.this;
        }
    }
}

