/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.mm.compression.dct.model;

public class PreDCT2 {
    public int N = 8;
    public int ROWS;
    public int COLS;
    public int QUALITY = 1;
    public double[][] c = new double[this.N][this.N];
    public double[][] cT = new double[this.N][this.N];
    public int[][] resultDCT = new int[this.ROWS][this.COLS];

    public PreDCT2() {
        this.initMatrix(this.QUALITY);
    }

    private void initMatrix(int n) {
        double d;
        int n2 = 0;
        while (n2 < this.N) {
            d = this.N;
            this.c[0][n2] = 1.0 / Math.sqrt(d);
            this.cT[n2][0] = this.c[0][n2];
            ++n2;
        }
        int n3 = 1;
        while (n3 < 8) {
            n2 = 0;
            while (n2 < 8) {
                d = n2;
                double d2 = n3;
                this.c[n3][n2] = Math.sqrt(0.25) * Math.cos((2.0 * d + 1.0) * d2 * Math.PI / 16.0);
                this.cT[n2][n3] = this.c[n3][n2];
                ++n2;
            }
            ++n3;
        }
    }

    public double[][] forwardDCT(int[][] nArray) {
        int n;
        int n2;
        double[][] dArray = new double[this.N][this.N];
        double[][] dArray2 = new double[this.N][this.N];
        int n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                dArray2[n3][n2] = 0.0;
                n = 0;
                while (n < this.N) {
                    double[] dArray3 = dArray2[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + (double)(nArray[n3][n] - 128) * this.cT[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                double d = 0.0;
                n = 0;
                while (n < this.N) {
                    d += this.c[n3][n] * dArray2[n][n2];
                    ++n;
                }
                dArray[n3][n2] = d;
                ++n2;
            }
            ++n3;
        }
        return dArray;
    }

    public int[][] inverseDCT(short[][] sArray) {
        int n;
        int n2;
        int[][] nArray = new int[this.N][this.N];
        double[][] dArray = new double[this.N][this.N];
        int n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                dArray[n3][n2] = 0.0;
                n = 0;
                while (n < this.N) {
                    double[] dArray2 = dArray[n3];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + (double)sArray[n3][n] * this.c[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.N) {
            n2 = 0;
            while (n2 < this.N) {
                double d = 0.0;
                n = 0;
                while (n < this.N) {
                    d += this.cT[n3][n] * dArray[n][n2];
                    ++n;
                }
                nArray[n3][n2] = (d += 128.0) < 0.0 ? 0 : (d > 255.0 ? 255 : (int)Math.round(d));
                ++n2;
            }
            ++n3;
        }
        return nArray;
    }
}

