/*
 * Decompiled with CFR 0.152.
 */
package kom.itbeankit.common.vcr;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ControlButtonPanel
extends Panel {
    Panel panel;
    Button stopButton;
    Button backwardsButton;
    Button stepButton;
    Button playButton;
    Button hideButton;
    Label userComplexityLevelLabel;
    Button levelDownButton;
    Button levelUpButton;
    private int theComplexityLevel = 1;
    private int numberOfComplexityLevels = 10;
    private Vector actionListeners = new Vector();
    private boolean play = false;
    public int timerDelay = 1000;
    public static final int STOP_BUTTON = 7000;
    public static final int BACKWARD_BUTTON = 7001;
    public static final int FORWARD_BUTTON = 7002;
    public static final int PLAY_BUTTON = 7003;
    public static final int HIDE_BUTTON = 7004;

    public ControlButtonPanel() {
        this.setLayout(new GridLayout());
        this.setBounds(0, 0, 462, 40);
        this.stopButton = new Button();
        this.stopButton.setLabel("stop");
        this.stopButton.setBounds(1, 0, 54, 40);
        this.stopButton.setBackground(new Color(0xC0C0C0));
        this.add(this.stopButton);
        this.stopButton.setCursor(new Cursor(12));
        this.backwardsButton = new Button();
        this.backwardsButton.setActionCommand("backwards");
        this.backwardsButton.setLabel("<< step");
        this.backwardsButton.setBounds(55, 0, 71, 40);
        this.backwardsButton.setBackground(new Color(0xC0C0C0));
        this.add(this.backwardsButton);
        this.backwardsButton.setCursor(new Cursor(12));
        this.stepButton = new Button();
        this.stepButton.setActionCommand("forwards");
        this.stepButton.setLabel("step >>");
        this.stepButton.setBounds(126, 0, 71, 40);
        this.stepButton.setBackground(new Color(0xC0C0C0));
        this.add(this.stepButton);
        this.stepButton.setCursor(new Cursor(12));
        this.playButton = new Button();
        this.playButton.setLabel("play");
        this.playButton.setBounds(197, 0, 52, 40);
        this.playButton.setBackground(new Color(0xC0C0C0));
        this.add(this.playButton);
        this.playButton.setCursor(new Cursor(12));
        this.hideButton = new Button();
        this.hideButton.setLabel("hide");
        this.hideButton.setBounds(249, 0, 54, 40);
        this.hideButton.setBackground(new Color(0xC0C0C0));
        this.add(this.hideButton);
        this.hideButton.setCursor(new Cursor(12));
        this.userComplexityLevelLabel = new Label("Level: ", 1);
        this.userComplexityLevelLabel.setBounds(308, 0, 65, 40);
        this.userComplexityLevelLabel.setBackground(new Color(0xFFFFFF));
        this.add(this.userComplexityLevelLabel);
        this.levelDownButton = new Button();
        this.levelDownButton.setActionCommand("levelDown");
        this.levelDownButton.setLabel("<<");
        this.levelDownButton.setBounds(373, 0, 44, 40);
        this.levelDownButton.setBackground(new Color(0xC0C0C0));
        this.add(this.levelDownButton);
        this.levelDownButton.setEnabled(false);
        this.levelDownButton.setCursor(new Cursor(12));
        this.levelUpButton = new Button();
        this.levelUpButton.setActionCommand("levelUp");
        this.levelUpButton.setLabel(">>");
        this.levelUpButton.setBounds(417, 0, 44, 40);
        this.levelUpButton.setBackground(new Color(0xC0C0C0));
        this.add(this.levelUpButton);
        this.levelUpButton.setCursor(new Cursor(12));
        this.theComplexityLevel = 1;
        this.userComplexityLevelLabel.setText(String.valueOf(this.userComplexityLevelLabel.getText()) + this.theComplexityLevel);
        SymAction lSymAction = new SymAction();
        this.playButton.addActionListener(lSymAction);
        this.stopButton.addActionListener(lSymAction);
        this.stepButton.addActionListener(lSymAction);
        this.backwardsButton.addActionListener(lSymAction);
        this.hideButton.addActionListener(lSymAction);
        this.levelDownButton.addActionListener(lSymAction);
        this.levelUpButton.addActionListener(lSymAction);
    }

    void playButton_ActionPerformed(ActionEvent event) {
        this.playButton.setLabel("play");
        this.fireActionEvent(this.playButton.getActionCommand());
    }

    void stopButton_ActionPerformed(ActionEvent event) {
        if (this.play) {
            this.playButton.setLabel("play");
        }
        this.play = false;
        this.fireActionEvent(this.stopButton.getActionCommand());
    }

    void stepButton_ActionPerformed(ActionEvent event) {
        this.fireActionEvent(this.stepButton.getActionCommand());
    }

    void backwardsButton_ActionPerformed(ActionEvent event) {
        this.fireActionEvent(this.backwardsButton.getActionCommand());
    }

    void hideButton_ActionPerformed(ActionEvent event) {
        this.fireActionEvent(this.hideButton.getActionCommand());
    }

    public void setNumberOfComplexityLevels(int nc) {
        this.numberOfComplexityLevels = nc;
        if (this.numberOfComplexityLevels == 1) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(false);
        }
    }

    public int getNumberOfComplexityLevels() {
        return this.numberOfComplexityLevels;
    }

    void levelDownButton_ActionPerformed(ActionEvent event) {
        if (this.theComplexityLevel == 2) {
            this.levelDownButton.setEnabled(false);
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel <= this.numberOfComplexityLevels & this.theComplexityLevel > 2) {
            this.levelUpButton.setEnabled(true);
            --this.theComplexityLevel;
        } else if (this.theComplexityLevel == 1) {
            this.levelDownButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelDownButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
        this.userComplexityLevelLabel.setAlignment(1);
    }

    void levelUpButton_ActionPerformed(ActionEvent event) {
        if (this.theComplexityLevel == this.numberOfComplexityLevels - 1) {
            this.levelUpButton.setEnabled(false);
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel >= 1 & this.theComplexityLevel < this.numberOfComplexityLevels) {
            this.levelDownButton.setEnabled(true);
            ++this.theComplexityLevel;
        } else if (this.theComplexityLevel == this.numberOfComplexityLevels) {
            this.levelUpButton.setEnabled(false);
        }
        this.fireActionEvent(this.levelUpButton.getActionCommand());
        this.userComplexityLevelLabel.setText("Level: " + this.theComplexityLevel);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners.addElement(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners.removeElement(l);
    }

    public void fireActionEvent(ActionEvent evt) {
        String actionCommand = evt.getActionCommand();
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener il = (ActionListener)this.actionListeners.elementAt(i);
            il.actionPerformed(new ActionEvent(this, 1001, actionCommand));
            ++i;
        }
    }

    public void fireActionEvent(String actionCommand) {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ActionListener il = (ActionListener)this.actionListeners.elementAt(i);
            il.actionPerformed(new ActionEvent(this, 1001, actionCommand));
            ++i;
        }
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int delayTime) {
        this.timerDelay = delayTime;
    }

    public void setComplexityLevel(int level) {
        this.theComplexityLevel = level;
    }

    public int getComplexityLevel() {
        return this.theComplexityLevel;
    }

    public void setEnabled(boolean flag) {
        this.stopButton.setEnabled(flag);
        this.stepButton.setEnabled(flag);
        this.backwardsButton.setEnabled(flag);
        this.playButton.setEnabled(flag);
    }

    public void setEnabled(int buttonNr, boolean flag) {
        switch (buttonNr) {
            case 7000: {
                this.stopButton.setEnabled(flag);
                break;
            }
            case 7001: {
                this.backwardsButton.setEnabled(flag);
                break;
            }
            case 7002: {
                this.stepButton.setEnabled(flag);
                break;
            }
            case 7003: {
                this.playButton.setEnabled(flag);
                break;
            }
            case 7004: {
                this.hideButton.setEnabled(flag);
                break;
            }
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ControlButtonPanel.this.playButton) {
                ControlButtonPanel.this.playButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.stopButton) {
                ControlButtonPanel.this.stopButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.stepButton) {
                ControlButtonPanel.this.stepButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.backwardsButton) {
                ControlButtonPanel.this.backwardsButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.hideButton) {
                ControlButtonPanel.this.hideButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.levelDownButton) {
                ControlButtonPanel.this.levelDownButton_ActionPerformed(event);
            } else if (object == ControlButtonPanel.this.levelUpButton) {
                ControlButtonPanel.this.levelUpButton_ActionPerformed(event);
            }
        }

        SymAction() {
            ControlButtonPanel.this = ControlButtonPanel.this;
        }
    }
}

