/*
 * Decompiled with CFR 0.152.
 */
import de.fub.bytecode.ClassPath;
import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ClassParser;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.DefaultVisitor;
import de.fub.bytecode.classfile.Deprecated;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.InnerClass;
import de.fub.bytecode.classfile.InnerClasses;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.Synthetic;
import de.fub.bytecode.classfile.Unknown;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import de.fub.bytecode.generic.BranchHandle;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.CodeExceptionGen;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.LineNumberGen;
import de.fub.bytecode.generic.LocalVariableGen;
import de.fub.bytecode.generic.MethodGen;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TABLESWITCH;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JasminVisitor
implements Visitor,
Constants {
    private JavaClass clazz;
    private PrintWriter out;
    private String class_name;
    private ConstantPoolGen cp;
    private Method method;
    private Hashtable map;

    public JasminVisitor(JavaClass clazz, OutputStream out) {
        this.clazz = clazz;
        this.out = new PrintWriter(out);
        this.class_name = clazz.getClassName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
    }

    public void disassemble() {
        new DefaultVisitor(this.clazz, this).visit();
        this.out.close();
    }

    private final String get(InstructionHandle ih) {
        String str = new StringTokenizer((String)this.map.get(ih), "\n").nextToken();
        return str.substring(0, str.length() - 1);
    }

    public static void main(String[] argv) {
        ClassParser parser = null;
        ClassPath class_path = new ClassPath();
        try {
            if (argv.length == 0) {
                System.err.println("disassemble: No input files specified");
            } else {
                int i = 0;
                while (i < argv.length) {
                    if (argv[i].endsWith(".class")) {
                        parser = new ClassParser(argv[i]);
                    } else {
                        InputStream is = class_path.getInputStream(argv[i]);
                        String name = String.valueOf(argv[i].replace('.', '/')) + ".class";
                        parser = new ClassParser(is, name);
                    }
                    JavaClass java_class = parser.parse();
                    String class_name = java_class.getClassName();
                    int index = class_name.lastIndexOf(46);
                    String path = class_name.substring(0, index + 1).replace('.', File.separatorChar);
                    class_name = class_name.substring(index + 1);
                    if (!path.equals("")) {
                        File f = new File(path);
                        f.mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(String.valueOf(path) + class_name + ".j");
                    new JasminVisitor(java_class, out).disassemble();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void printEndMethod(Attribute attr) {
        Attribute[] attributes = this.method.getAttributes();
        if (attr == attributes[attributes.length - 1]) {
            this.out.println(".end method");
        }
    }

    private final void put(InstructionHandle ih, String line) {
        String str = (String)this.map.get(ih);
        if (str == null) {
            this.map.put(ih, line);
        } else {
            if (line.startsWith("Label") || str.endsWith(line)) {
                return;
            }
            this.map.put(ih, String.valueOf(str) + "\n" + line);
        }
    }

    public void visitCode(Code code) {
        int label_counter = 0;
        this.out.println(".limit stack " + code.getMaxStack());
        this.out.println(".limit locals " + code.getMaxLocals());
        MethodGen mg = new MethodGen(this.method, this.class_name, this.cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        this.map = new Hashtable();
        int i = 0;
        while (i < ihs.length) {
            if (ihs[i] instanceof BranchHandle) {
                BranchInstruction bi = (BranchInstruction)ihs[i].getInstruction();
                if (bi instanceof Select) {
                    InstructionHandle[] targets = ((Select)bi).getTargets();
                    int j = 0;
                    while (j < targets.length) {
                        this.put(targets[j], "Label" + label_counter++ + ":");
                        ++j;
                    }
                }
                InstructionHandle ih = bi.getTarget();
                this.put(ih, "Label" + label_counter++ + ":");
            }
            ++i;
        }
        LocalVariableGen[] lvs = mg.getLocalVariables();
        int i2 = 0;
        while (i2 < lvs.length) {
            InstructionHandle ih = lvs[i2].getStart();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = lvs[i2].getEnd();
            this.put(ih, "Label" + label_counter++ + ":");
            ++i2;
        }
        CodeExceptionGen[] ehs = mg.getExceptionHandlers();
        int i3 = 0;
        while (i3 < ehs.length) {
            CodeExceptionGen c = ehs[i3];
            InstructionHandle ih = c.getStartPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getEndPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getHandlerPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ++i3;
        }
        LineNumberGen[] lns = mg.getLineNumbers();
        int i4 = 0;
        while (i4 < lns.length) {
            InstructionHandle ih = lns[i4].getInstruction();
            this.put(ih, ".line " + lns[i4].getSourceLine());
            ++i4;
        }
        int i5 = 0;
        while (i5 < lvs.length) {
            LocalVariableGen l = lvs[i5];
            this.out.println(".var " + l.getIndex() + " is " + l.getName() + " " + l.getType().getSignature() + " from " + this.get(l.getStart()) + " to " + this.get(l.getEnd()));
            ++i5;
        }
        this.out.print("\n");
        int i6 = 0;
        while (i6 < ihs.length) {
            InstructionHandle ih = ihs[i6];
            Instruction inst = ih.getInstruction();
            String str = (String)this.map.get(ih);
            if (str != null) {
                this.out.println(str);
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    int j;
                    Select s = (Select)inst;
                    int[] matchs = s.getMatchs();
                    InstructionHandle[] targets = s.getTargets();
                    if (s instanceof TABLESWITCH) {
                        this.out.println("\ttableswitch " + matchs[0] + " " + matchs[matchs.length - 1]);
                        j = 0;
                        while (j < targets.length) {
                            this.out.println("\t\t" + this.get(targets[j]));
                            ++j;
                        }
                    } else {
                        this.out.println("\tlookupswitch ");
                        j = 0;
                        while (j < targets.length) {
                            this.out.println("\t\t" + matchs[j] + " : " + this.get(targets[j]));
                            ++j;
                        }
                    }
                    this.out.println("\t\tdefault: " + this.get(s.getTarget()));
                } else {
                    BranchInstruction bi = (BranchInstruction)inst;
                    ih = bi.getTarget();
                    str = this.get(ih);
                    this.out.println("\t" + Constants.OPCODE_NAMES[bi.getTag()] + " " + str);
                }
            } else {
                this.out.println("\t" + inst.toString(this.cp.getConstantPool()));
            }
            ++i6;
        }
        this.out.print("\n");
        int i7 = 0;
        while (i7 < ehs.length) {
            CodeExceptionGen c = ehs[i7];
            ObjectType caught = c.getCatchType();
            String class_name = caught == null ? "all" : caught.getClassName().replace('.', '/');
            this.out.println(".catch " + class_name + " from " + this.get(c.getStartPC()) + " to " + this.get(c.getEndPC()) + " using " + this.get(c.getHandlerPC()));
            ++i7;
        }
        this.printEndMethod(code);
    }

    public void visitCodeException(CodeException obj) {
    }

    public void visitConstantClass(ConstantClass obj) {
    }

    public void visitConstantDouble(ConstantDouble obj) {
    }

    public void visitConstantFieldref(ConstantFieldref obj) {
    }

    public void visitConstantFloat(ConstantFloat obj) {
    }

    public void visitConstantInteger(ConstantInteger obj) {
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref obj) {
    }

    public void visitConstantLong(ConstantLong obj) {
    }

    public void visitConstantMethodref(ConstantMethodref obj) {
    }

    public void visitConstantNameAndType(ConstantNameAndType obj) {
    }

    public void visitConstantPool(ConstantPool obj) {
    }

    public void visitConstantString(ConstantString obj) {
    }

    public void visitConstantUtf8(ConstantUtf8 obj) {
    }

    public void visitConstantValue(ConstantValue cv) {
        this.out.println(" = " + cv);
    }

    public void visitDeprecated(Deprecated attribute) {
        this.printEndMethod(attribute);
    }

    public void visitExceptionTable(ExceptionTable e) {
        String[] names = e.getExceptionNames();
        int i = 0;
        while (i < names.length) {
            this.out.println(".throws " + names[i].replace('.', '/'));
            ++i;
        }
        this.printEndMethod(e);
    }

    public void visitField(Field field) {
        this.out.print(".field " + Utility.accessToString(field.getAccessFlags()) + " " + field.getName() + " " + field.getSignature());
        if (field.getAttributes().length == 0) {
            this.out.print("\n");
        }
    }

    public void visitInnerClass(InnerClass obj) {
    }

    public void visitInnerClasses(InnerClasses obj) {
    }

    public void visitJavaClass(JavaClass clazz) {
        this.out.println(";; Produced by JasminVisitor (JavaClass package)");
        this.out.println(";; http://www.inf.fu-berlin.de/~dahm/JavaClass/");
        this.out.println(";; " + new Date() + "\n");
        this.out.println(".source " + clazz.getSourceFileName());
        this.out.println("." + Utility.classOrInterface(clazz.getAccessFlags()) + " " + Utility.accessToString(clazz.getAccessFlags(), true) + " " + clazz.getClassName().replace('.', '/'));
        this.out.println(".super " + clazz.getSuperclassName().replace('.', '/'));
        String[] interfaces = clazz.getInterfaceNames();
        int i = 0;
        while (i < interfaces.length) {
            this.out.println(".implements " + interfaces[i].replace('.', '/'));
            ++i;
        }
        this.out.print("\n");
    }

    public void visitLineNumber(LineNumber obj) {
    }

    public void visitLineNumberTable(LineNumberTable obj) {
    }

    public void visitLocalVariable(LocalVariable obj) {
    }

    public void visitLocalVariableTable(LocalVariableTable obj) {
    }

    public void visitMethod(Method method) {
        this.out.println("\n.method " + Utility.accessToString(method.getAccessFlags()) + " " + method.getName() + method.getSignature());
        this.method = method;
        Attribute[] attributes = method.getAttributes();
        if (attributes == null || attributes.length == 0) {
            this.out.println(".end method");
        }
    }

    public void visitSourceFile(SourceFile obj) {
    }

    public void visitSynthetic(Synthetic attribute) {
        this.printEndMethod(attribute);
    }

    public void visitUnknown(Unknown obj) {
    }
}

