/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public ClassPath(String class_path) {
        Vector<PathEntry> vec = new Vector<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.addElement(new Dir(path));
                    continue;
                }
                vec.addElement(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.copyInto(this.paths);
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public byte[] getBytes(String name, String suffix) throws IOException {
        InputStream is = this.getInputStream(name, suffix);
        if (is == null) {
            throw new IOException("Couldn't find: " + name + suffix);
        }
        DataInputStream dis = new DataInputStream(is);
        byte[] bytes = new byte[is.available()];
        dis.readFully(bytes);
        dis.close();
        is.close();
        return bytes;
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        int i = 0;
        while (i < this.paths.length) {
            ClassFile cf = this.paths[i].getClassFile(name, suffix);
            if (cf != null) {
                return cf;
            }
            ++i;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private static final String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        Vector<String> list = new Vector<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        Vector dirs = new Vector();
        ClassPath.getPathComponents(ext_path, dirs);
        Enumeration e = dirs.elements();
        while (e.hasMoreElements()) {
            File ext_dir = new File((String)e.nextElement());
            String[] extensions = ext_dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extensions == null) continue;
            int i = 0;
            while (i < extensions.length) {
                list.addElement(String.valueOf(ext_path) + File.separatorChar + extensions[i]);
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        Enumeration e2 = list.elements();
        while (e2.hasMoreElements()) {
            buf.append((String)e2.nextElement());
            if (!e2.hasMoreElements()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getInputStream();
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static final void getPathComponents(String path, Vector list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.addElement(name);
            }
        }
    }

    private static abstract class PathEntry {
        PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();

        public abstract long getSize();

        public abstract long getTime();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String d) {
            this.dir = d;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(file){
                private final /* synthetic */ File val$file;
                {
                    this.val$file = val$file;
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                public long getSize() {
                    return this.val$file.length();
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        static /* synthetic */ ZipFile access$0(Zip $0) {
            return $0.zip;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            ZipEntry entry = this.zip.getEntry(String.valueOf(name.replace('.', '/')) + suffix);
            return entry != null ? new ClassFile(entry, this){
                private final /* synthetic */ ZipEntry val$entry;
                private final /* synthetic */ Zip this$0;
                {
                    this.val$entry = val$entry;
                    this.this$0 = this$0;
                }

                public InputStream getInputStream() throws IOException {
                    return Zip.access$0(this.this$0).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }
            } : null;
        }
    }
}

