/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantvalue_index;

    public ConstantValue(int name_index, int length, int constantvalue_index, ConstantPool constant_pool) {
        super((byte)1, name_index, length, constant_pool);
        this.constantvalue_index = constantvalue_index;
    }

    ConstantValue(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), constant_pool);
    }

    public ConstantValue(ConstantValue c) {
        this(c.getNameIndex(), c.getLength(), c.getConstantValueIndex(), c.getConstantPool());
    }

    public void accept(Visitor v) {
        v.visitConstantValue(this);
    }

    private static final String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\'': {
                    buf.append("\\'");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                    break;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        ConstantValue c = (ConstantValue)this.clone();
        c.constant_pool = constant_pool;
        return c;
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.constantvalue_index);
    }

    public final int getConstantValueIndex() {
        return this.constantvalue_index;
    }

    public final void setConstantValueIndex(int constantvalue_index) {
        this.constantvalue_index = constantvalue_index;
    }

    public final String toString() throws InternalError {
        String buf;
        Constant c = this.constant_pool.getConstant(this.constantvalue_index);
        switch (c.getTag()) {
            case 5: {
                buf = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 4: {
                buf = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 6: {
                buf = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 3: {
                buf = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.constant_pool.getConstant(i, (byte)1);
                buf = "\"" + ConstantValue.convertString(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            default: {
                throw new InternalError("Type of ConstValue invalid: " + c);
            }
        }
        return buf;
    }
}

