/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.Deprecated;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.InnerClass;
import de.fub.bytecode.classfile.InnerClasses;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.Synthetic;
import de.fub.bytecode.classfile.Unknown;
import de.fub.bytecode.classfile.Visitor;

public class DefaultVisitor
implements Visitor {
    private JavaClass clazz;
    private Visitor visitor;

    public DefaultVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    public void visitCode(Code code) {
        code.accept(this.visitor);
        CodeException[] table = code.getExceptionTable();
        int i = 0;
        while (i < table.length) {
            table[i].accept(this);
            ++i;
        }
        Attribute[] attributes = code.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            attributes[i2].accept(this);
            ++i2;
        }
    }

    public void visitCodeException(CodeException ce) {
        ce.accept(this.visitor);
    }

    public void visitConstantClass(ConstantClass constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantDouble(ConstantDouble constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantFieldref(ConstantFieldref constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantFloat(ConstantFloat constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantInteger(ConstantInteger constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantLong(ConstantLong constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantMethodref(ConstantMethodref constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantNameAndType(ConstantNameAndType constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantPool(ConstantPool cp) {
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        int i = 1;
        while (i < constants.length) {
            if (constants[i] != null) {
                constants[i].accept(this);
            }
            ++i;
        }
    }

    public void visitConstantString(ConstantString constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantUtf8(ConstantUtf8 constant) {
        constant.accept(this.visitor);
    }

    public void visitConstantValue(ConstantValue cv) {
        cv.accept(this.visitor);
    }

    public void visitDeprecated(Deprecated attribute) {
        attribute.accept(this.visitor);
    }

    public void visitExceptionTable(ExceptionTable table) {
        table.accept(this.visitor);
    }

    public void visitField(Field field) {
        field.accept(this.visitor);
        Attribute[] attributes = field.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
    }

    public void visitInnerClass(InnerClass inner) {
        inner.accept(this.visitor);
    }

    public void visitInnerClasses(InnerClasses ic) {
        ic.accept(this.visitor);
        InnerClass[] ics = ic.getInnerClasses();
        int i = 0;
        while (i < ics.length) {
            ics[i].accept(this);
            ++i;
        }
    }

    public void visitJavaClass(JavaClass clazz) {
        clazz.accept(this.visitor);
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].accept(this);
            ++i;
        }
        Method[] methods = clazz.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            methods[i2].accept(this);
            ++i2;
        }
        Attribute[] attributes = clazz.getAttributes();
        int i3 = 0;
        while (i3 < attributes.length) {
            attributes[i3].accept(this);
            ++i3;
        }
        clazz.getConstantPool().accept(this);
    }

    public void visitLineNumber(LineNumber number) {
        number.accept(this.visitor);
    }

    public void visitLineNumberTable(LineNumberTable table) {
        table.accept(this.visitor);
        LineNumber[] numbers = table.getLineNumberTable();
        int i = 0;
        while (i < numbers.length) {
            numbers[i].accept(this);
            ++i;
        }
    }

    public void visitLocalVariable(LocalVariable var) {
        var.accept(this.visitor);
    }

    public void visitLocalVariableTable(LocalVariableTable table) {
        table.accept(this.visitor);
        LocalVariable[] vars = table.getLocalVariableTable();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept(this);
            ++i;
        }
    }

    public void visitMethod(Method method) {
        method.accept(this.visitor);
        Attribute[] attributes = method.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            attributes[i].accept(this);
            ++i;
        }
    }

    public void visitSourceFile(SourceFile attribute) {
        attribute.accept(this.visitor);
    }

    public void visitSynthetic(Synthetic attribute) {
        attribute.accept(this.visitor);
    }

    public void visitUnknown(Unknown attribute) {
        attribute.accept(this.visitor);
    }
}

