/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.FieldOrMethod;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Field
extends FieldOrMethod {
    public Field(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public Field(Field c) {
        super(c);
    }

    Field(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatError {
        super(file, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitField(this);
    }

    public final Field copy(ConstantPool constant_pool) {
        return (Field)this.copy_(constant_pool);
    }

    public final ConstantValue getConstantValue() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i].getTag() == 1) {
                return (ConstantValue)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuffer buf = new StringBuffer(String.valueOf(access) + signature + " " + name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = " + cv);
        }
        int i = 0;
        while (i < this.attributes_count) {
            Attribute a = this.attributes[i];
            if (!(a instanceof ConstantValue)) {
                buf.append(" <" + a.toString() + ">");
            }
            ++i;
        }
        return buf.toString();
    }
}

