/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.FieldOrMethod;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public Method(Method c) {
        super(c);
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatError {
        super(file, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitMethod(this);
    }

    public final Method copy(ConstantPool constant_pool) {
        return (Method)this.copy_(constant_pool);
    }

    public final Code getCode() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof Code) {
                return (Code)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof ExceptionTable) {
                return (ExceptionTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access);
        StringBuffer buf = new StringBuffer(signature);
        int i = 0;
        while (i < this.attributes_count) {
            Attribute a = this.attributes[i];
            if (!(a instanceof Code) && !(a instanceof ExceptionTable)) {
                buf.append(" <" + a.toString() + ">");
            }
            ++i;
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows " + str);
        }
        return buf.toString();
    }
}

