/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private String name;
    private static Hashtable unknown_attributes = new Hashtable();

    Unknown(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            file.readFully(this.bytes);
        }
    }

    public Unknown(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = ((ConstantUtf8)constant_pool.getConstant(name_index, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    public Unknown(Unknown c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    public void accept(Visitor v) {
        v.visitUnknown(this);
    }

    public Attribute copy(ConstantPool constant_pool) {
        Unknown c = (Unknown)this.clone();
        if (this.bytes != null) {
            c.bytes = (byte[])this.bytes.clone();
        }
        c.constant_pool = constant_pool;
        return c;
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.length > 0) {
            file.write(this.bytes, 0, this.length);
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final String getName() {
        return this.name;
    }

    static Unknown[] getUnknownAttributes() {
        Unknown[] unknowns = new Unknown[unknown_attributes.size()];
        Enumeration entries = unknown_attributes.elements();
        int i = 0;
        while (entries.hasMoreElements()) {
            unknowns[i] = (Unknown)entries.nextElement();
            ++i;
        }
        unknown_attributes = new Hashtable();
        return unknowns;
    }

    public final void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public final String toString() {
        String hex;
        if (this.length == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (this.length > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = String.valueOf(Utility.toHexString(tmp)) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }
}

