/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.util.ByteSequence;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class Utility
implements Constants {
    private static int consumed_chars;
    private static boolean wide;

    static {
        wide = false;
    }

    public static final String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static final String accessToString(int access_flags, boolean for_class) {
        StringBuffer buf = new StringBuffer();
        int p = 0;
        int i = 0;
        while (p < 1024) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(String.valueOf(Constants.ACCESS_NAMES[i]) + " ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    private static final short byteToShort(byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static final String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static final int clearBit(int flag, int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static final String codeToString(ByteSequence bytes, ConstantPool constant_pool, boolean verbose) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(Constants.OPCODE_NAMES[opcode]);
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            i = 0;
            while (i < no_pad_bytes) {
                byte b = bytes.readByte();
                if (b != 0) {
                    System.err.println("Ooops. Padding byte != 0 " + b);
                }
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = " + (default_offset += offset) + ", low = " + low + ", high = " + high + "(");
                int[] jump_table = new int[high - low + 1];
                int i2 = 0;
                while (i2 < jump_table.length) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append(jump_table[i2]);
                    if (i2 < jump_table.length - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = " + (default_offset += offset) + ", npairs = " + npairs + " (");
                int i2 = 0;
                while (i2 < npairs) {
                    match[i2] = bytes.readInt();
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("(" + match[i2] + ", " + jump_table[i2] + ")");
                    if (i2 < npairs - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#" + (bytes.getIndex() - 1 + bytes.readShort()));
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#" + (bytes.getIndex() - 1 + bytes.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%" + vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<" + Constants.TYPE_NAMES[bytes.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index, (byte)9) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<" + constant_pool.constantToString(index, (byte)7) + ">" + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                buf.append("\t" + constant_pool.constantToString(index, (byte)10) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t" + constant_pool.constantToString(index, (byte)11) + (verbose ? " (" + index + ")\t" : "") + nargs + "\t" + bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index, constant_pool.getConstant(index).getTag()) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t" + constant_pool.constantToString(index, constant_pool.getConstant(index).getTag()) + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<" + Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false) + ">" + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<" + Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false) + ">\t" + dimensions + (verbose ? " (" + index + ")" : ""));
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%" + vindex + "\t" + constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                i = 0;
                while (i < Constants.TYPE_OF_OPERANDS[opcode].length) {
                    buf.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i]) {
                        case 8: {
                            buf.append(bytes.readByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        return buf.toString();
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index, int length, boolean verbose) {
        StringBuffer buf = new StringBuffer(code.length * 20);
        ByteSequence stream = new ByteSequence(code);
        try {
            int i = 0;
            while (i < index) {
                Utility.codeToString(stream, constant_pool, verbose);
                ++i;
            }
            int i2 = 0;
            while (stream.available() > 0) {
                if (length < 0 || i2 < length) {
                    String indices = Utility.fillup(String.valueOf(stream.getIndex()) + ":", 6, true, ' ');
                    buf.append(String.valueOf(indices) + Utility.codeToString(stream, constant_pool, verbose) + '\n');
                }
                ++i2;
            }
        }
        catch (IOException e) {
            System.out.println(buf.toString());
            e.printStackTrace();
            throw new ClassFormatError("Byte code error: " + e);
        }
        return buf.toString();
    }

    public static final String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    static final boolean equals(byte[] a, byte[] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String fillup(String str, int length, boolean left_justify, char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        int j = 0;
        while (j < buf.length) {
            buf[j] = fill;
            ++j;
        }
        if (left_justify) {
            return String.valueOf(str) + new String(buf);
        }
        return String.valueOf(new String(buf)) + str;
    }

    public static final String format(int i, int length, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i), length, left_justify, fill);
    }

    public static final boolean isSet(int flag, int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    private static final boolean is_digit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final boolean is_space(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static final String[] methodSignatureArgumentTypes(String signature) throws ClassFormatError {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatError {
        Vector<String> vec = new Vector<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.addElement(Utility.signatureToString(signature.substring(index), chopit));
                index += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        Object[] types = new String[vec.size()];
        vec.copyInto(types);
        return types;
    }

    public static final String methodSignatureReturnType(String signature) throws ClassFormatError {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static final String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatError {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            type = Utility.signatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        return type;
    }

    public static final String methodSignatureToString(String signature, String name, String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static final String methodSignatureToString(String signature, String name, String access, boolean chopit) throws ClassFormatError {
        String type;
        StringBuffer buf = new StringBuffer("(");
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                buf.append(String.valueOf(Utility.signatureToString(signature.substring(index), chopit)) + ", ");
                index += consumed_chars;
            }
            type = Utility.signatureToString(signature.substring(++index), chopit);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return String.valueOf(access) + (access.length() > 0 ? " " : "") + type + " " + name + buf.toString();
    }

    public static final String methodTypeToSignature(String ret, String[] argv) throws ClassFormatError {
        String str;
        StringBuffer buf = new StringBuffer("(");
        if (argv != null) {
            int i = 0;
            while (i < argv.length) {
                str = Utility.typeToSignature(argv[i]);
                if (str.endsWith("V")) {
                    throw new ClassFormatError("Invalid type: " + argv[i]);
                }
                buf.append(str);
                ++i;
            }
        }
        str = Utility.typeToSignature(ret);
        buf.append(")" + str);
        return buf.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    public static final void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static final String printArray(Object[] obj, boolean braces) {
        if (obj == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (braces) {
            buf.append('{');
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                buf.append(obj[i].toString());
            } else {
                buf.append("null");
            }
            if (i < obj.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static final String replace(String str, String old, String new_) {
        StringBuffer buf = new StringBuffer();
        try {
            int index = str.indexOf(old);
            if (index != -1) {
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return str;
    }

    public static final int setBit(int flag, int i) {
        return flag | Utility.pow2(i);
    }

    public static final String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static final String signatureToString(String signature, boolean chopit) {
        consumed_chars = 1;
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatError("Invalid signature: " + signature);
                    }
                    consumed_chars = index + 1;
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumed_chars = n;
                    String type = Utility.signatureToString(signature.substring(n), chopit);
                    Utility.consumed_chars += consumed_chars;
                    return String.valueOf(type) + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatError("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatError("Invalid signature: " + e + ":" + signature);
        }
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            short b = Utility.byteToShort(bytes[i]);
            String hex = Integer.toString(b, 16);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i < bytes.length - 1) {
                buf.append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    public static final byte typeOfMethodSignature(String signature) throws ClassFormatError {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
    }

    public static final byte typeOfSignature(String signature) throws ClassFormatError {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String typeToSignature(String str) throws ClassFormatError {
        void var5_6;
        String type;
        int index = str.indexOf(91);
        String array = null;
        String code = null;
        try {
            if (index > -1) {
                type = str.substring(0, index);
                array = str.substring(index);
            } else {
                type = str;
            }
            if (array == null) {
                array = "";
            } else {
                StringBuffer buf = new StringBuffer();
                char lastchar = 'X';
                int i = 0;
                while (i < array.length()) {
                    char ch = array.charAt(i);
                    if (ch == '[') {
                        buf.append('[');
                    } else if (ch != ']' && !Utility.is_space(ch)) {
                        if (!Utility.is_digit(ch)) throw new ClassFormatError("Invalid type: " + str);
                        if (lastchar != '[' && !Utility.is_digit(lastchar)) throw new ClassFormatError("Invalid type: " + str);
                        buf.append(ch);
                    }
                    lastchar = ch;
                    ++i;
                }
                array = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid type: " + str);
        }
        int i = 4;
        while (var5_6 <= 12) {
            if (type.equals(Constants.TYPE_NAMES[var5_6])) {
                code = Constants.SHORT_TYPE_NAMES[var5_6];
                break;
            }
            ++var5_6;
        }
        if (var5_6 == 12) {
            if (!array.startsWith("[")) return String.valueOf(array) + code;
            throw new ClassFormatError("Invalid type: " + str);
        }
        if (var5_6 <= 12) return String.valueOf(array) + code;
        code = "L" + type.replace('.', '/') + ";";
        return String.valueOf(array) + code;
    }
}

