/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionTargeter;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    protected int index;
    protected InstructionHandle target;
    protected int position;

    BranchInstruction() {
    }

    protected BranchInstruction(short tag, InstructionHandle target) {
        super(tag, (short)3);
        this.setTarget(target);
    }

    public boolean containsTarget(InstructionHandle ih) {
        return this.target == ih;
    }

    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        this.index = this.getTargetOffset();
        if (Math.abs(this.index) >= Short.MAX_VALUE) {
            throw new ClassGenException("Branch target offset too large for short");
        }
        out.writeShort(this.index);
    }

    final int getIndex() {
        return this.index;
    }

    public InstructionHandle getTarget() {
        return this.target;
    }

    protected int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected int getTargetOffset(InstructionHandle target) {
        if (target == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int t = target.getPosition();
        if (t < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + t + ":" + target);
        }
        return t - this.position;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)3;
        this.index = bytes.readShort();
    }

    static final void notifyTarget(InstructionHandle old_ih, InstructionHandle new_ih, InstructionTargeter t) {
        if (old_ih != null) {
            old_ih.removeTargeter(t);
        }
        if (new_ih != null) {
            new_ih.addTargeter(t);
        }
    }

    public void setTarget(InstructionHandle target) {
        BranchInstruction.notifyTarget(this.target, target, this);
        this.target = target;
    }

    public String toString(boolean verbose) {
        String s = super.toString(verbose);
        String t = "null";
        if (verbose) {
            if (this.target != null) {
                t = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : this.target.getInstruction().toString(verbose));
            }
        } else {
            this.index = this.getTargetOffset();
            t = String.valueOf(this.index + this.position);
        }
        return String.valueOf(s) + " -> " + t;
    }

    protected int updatePosition(int offset, int max_offset) {
        this.position += offset;
        return 0;
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        if (this.target != old_ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.target);
        }
        this.setTarget(new_ih);
    }
}

