/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.AccessFlags;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.INVOKESPECIAL;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.MethodGen;
import de.fub.bytecode.generic.Type;
import java.util.Enumeration;
import java.util.Vector;

public class ClassGen
extends AccessFlags
implements Constants {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index;
    private int superclass_name_index;
    private ConstantPoolGen cp;
    private Vector field_vec = new Vector();
    private Vector method_vec = new Vector();
    private Vector attribute_vec = new Vector();
    private Vector interface_vec = new Vector();

    public ClassGen(JavaClass clazz) {
        this.class_name_index = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.class_name = clazz.getClassName();
        this.super_class_name = clazz.getSuperclassName();
        this.file_name = clazz.getSourceFileName();
        this.access_flags = clazz.getAccessFlags();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        Attribute[] attributes = clazz.getAttributes();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        int[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.addInterface(interfaces[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < attributes.length) {
            this.addAttribute(attributes[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < methods.length) {
            this.addMethod(methods[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < fields.length) {
            this.addField(fields[i4]);
            ++i4;
        }
    }

    public ClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces) {
        this.class_name = class_name;
        this.super_class_name = super_class_name;
        this.file_name = file_name;
        this.access_flags = access_flags;
        this.cp = new ConstantPoolGen();
        this.addAttribute(new SourceFile(this.cp.addUtf8("SourceFile"), 2, this.cp.addUtf8(file_name), this.cp.getConstantPool()));
        this.class_name_index = this.cp.addClass(class_name);
        this.superclass_name_index = this.cp.addClass(super_class_name);
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                this.addInterface(interfaces[i]);
                ++i;
            }
        }
    }

    public void addAttribute(Attribute a) {
        this.attribute_vec.addElement(a);
    }

    public void addEmptyConstructor(int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConstants.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        il.append(InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(Field f) {
        this.field_vec.addElement(f);
    }

    public void addInterface(int i) {
        this.interface_vec.addElement(new Int(i));
    }

    public void addInterface(String i) {
        this.addInterface(this.cp.addClass(i));
    }

    public void addMethod(Method m) {
        this.method_vec.addElement(m);
    }

    public boolean containsField(Field f) {
        return this.field_vec.contains(f);
    }

    public Field containsField(String name) {
        Enumeration e = this.field_vec.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Method containsMethod(String name, String signature) {
        Enumeration e = this.method_vec.elements();
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            if (!m.getName().equals(name) || !m.getSignature().equals(signature)) continue;
            return m;
        }
        return null;
    }

    public Attribute[] getAttributes() {
        Object[] attributes = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.copyInto(attributes);
        return attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public Field[] getFields() {
        Object[] fields = new Field[this.field_vec.size()];
        this.field_vec.copyInto(fields);
        return fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public int[] getInterfaces() {
        int size = this.interface_vec.size();
        int[] interfaces = new int[size];
        int i = 0;
        while (i < size) {
            interfaces[i] = ((Int)this.interface_vec.elementAt((int)i)).value;
            ++i;
        }
        return interfaces;
    }

    public JavaClass getJavaClass() {
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, 45, 3, this.access_flags, this.cp.getFinalConstantPool(), this.getInterfaces(), this.getFields(), this.getMethods(), this.getAttributes());
    }

    public Method[] getMethods() {
        Object[] methods = new Method[this.method_vec.size()];
        this.method_vec.copyInto(methods);
        return methods;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void removeAttribute(Attribute a) {
        this.attribute_vec.removeElement(a);
    }

    public void removeField(Field f) {
        this.field_vec.removeElement(f);
    }

    public void removeInterface(int i) {
        if ((i = this.interface_vec.indexOf(new Int(i))) >= 0) {
            this.interface_vec.removeElementAt(i);
        }
    }

    public void removeMethod(Method m) {
        this.method_vec.removeElement(m);
    }

    public void setClassNameIndex(int class_name_index) {
        this.class_name_index = class_name_index;
        this.class_name = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setConstantPool(ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setMethods(Method[] methods) {
        this.method_vec.removeAllElements();
        int m = 0;
        while (m < methods.length) {
            this.addMethod(methods[m]);
            ++m;
        }
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.super_class_name = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    private static final class Int {
        int value;

        Int(int i) {
            this.value = i;
        }

        public boolean equals(Object o) {
            return this.value == ((Int)o).value;
        }

        public int hashcode() {
            return this.value;
        }
    }
}

