/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantCP;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.MethodGen;
import de.fub.bytecode.generic.ObjectType;
import java.util.Hashtable;

public class ConstantPoolGen
implements Constants {
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private Hashtable string_table = new Hashtable();
    private Hashtable class_table = new Hashtable();
    private Hashtable n_a_t_table = new Hashtable();
    private Hashtable cp_table = new Hashtable();

    public ConstantPoolGen() {
    }

    public ConstantPoolGen(ConstantPool cp) {
        this(cp.getConstantPool());
    }

    public ConstantPoolGen(Constant[] cs) {
        if (cs.length > this.size) {
            this.size = cs.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(cs, 0, this.constants, 0, cs.length);
        if (cs.length > 0) {
            this.index = cs.length;
        }
        int i = 1;
        while (i < this.index) {
            ConstantUtf8 u8;
            Constant s;
            Constant c = this.constants[i];
            if (c instanceof ConstantString) {
                s = (ConstantString)c;
                u8 = (ConstantUtf8)this.constants[((ConstantString)s).getStringIndex()];
                this.string_table.put(u8.getBytes(), new Index(i));
            } else if (c instanceof ConstantClass) {
                s = (ConstantClass)c;
                u8 = (ConstantUtf8)this.constants[((ConstantClass)s).getNameIndex()];
                this.class_table.put(u8.getBytes(), new Index(i));
            } else if (c instanceof ConstantNameAndType) {
                ConstantNameAndType n = (ConstantNameAndType)c;
                u8 = (ConstantUtf8)this.constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                this.n_a_t_table.put(String.valueOf(u8.getBytes()) + NAT_DELIM + u8_2.getBytes(), new Index(i));
            } else if (c instanceof ConstantCP) {
                ConstantCP m = (ConstantCP)c;
                ConstantClass clazz = (ConstantClass)this.constants[m.getClassIndex()];
                ConstantNameAndType n = (ConstantNameAndType)this.constants[m.getNameAndTypeIndex()];
                ConstantUtf8 u82 = (ConstantUtf8)this.constants[clazz.getNameIndex()];
                String class_name = u82.getBytes().replace('/', '.');
                u82 = (ConstantUtf8)this.constants[n.getNameIndex()];
                String method_name = u82.getBytes();
                u82 = (ConstantUtf8)this.constants[n.getSignatureIndex()];
                String signature = u82.getBytes();
                String delim = METHODREF_DELIM;
                if (c instanceof ConstantInterfaceMethodref) {
                    delim = IMETHODREF_DELIM;
                } else if (c instanceof ConstantFieldref) {
                    delim = FIELDREF_DELIM;
                }
                this.cp_table.put(String.valueOf(class_name) + delim + method_name + delim + signature, new Index(i));
            }
            ++i;
        }
    }

    public int addArrayClass(ArrayType type) {
        return this.addClass_(type.getSignature());
    }

    public int addClass(ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public int addClass(String str) {
        return this.addClass_(str.replace('.', '/'));
    }

    private int addClass_(String clazz) {
        int ret = this.lookupClass(clazz);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c = new ConstantClass(this.addUtf8(clazz));
        ret = this.index;
        this.constants[this.index++] = c;
        this.class_table.put(clazz, new Index(ret));
        return ret;
    }

    public int addDouble(double n) {
        int ret = this.lookupDouble(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantDouble(n);
        this.index += 2;
        return ret;
    }

    public int addFieldref(String class_name, String field_name, String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantFieldref(class_index, name_and_type_index);
        this.cp_table.put(String.valueOf(class_name) + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addFloat(float n) {
        int ret = this.lookupFloat(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantFloat(n);
        return ret;
    }

    public int addInteger(int n) {
        int ret = this.lookupInteger(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return ret;
    }

    public int addInterfaceMethodref(MethodGen method) {
        return this.addInterfaceMethodref(method.getClassName(), method.getMethodName(), method.getMethodSignature());
    }

    public int addInterfaceMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        this.cp_table.put(String.valueOf(class_name) + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addLong(long n) {
        int ret = this.lookupLong(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index] = new ConstantLong(n);
        this.index += 2;
        return ret;
    }

    public int addMethodref(MethodGen method) {
        return this.addMethodref(method.getClassName(), method.getMethodName(), method.getMethodSignature());
    }

    public int addMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.index;
        this.constants[this.index++] = new ConstantMethodref(class_index, name_and_type_index);
        this.cp_table.put(String.valueOf(class_name) + METHODREF_DELIM + method_name + METHODREF_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addNameAndType(String name, String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.index;
        this.constants[this.index++] = new ConstantNameAndType(name_index, signature_index);
        this.n_a_t_table.put(String.valueOf(name) + NAT_DELIM + signature, new Index(ret));
        return ret;
    }

    public int addString(String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantUtf8 u8 = new ConstantUtf8(str);
        ConstantString s = new ConstantString(this.index);
        this.constants[this.index++] = u8;
        ret = this.index;
        this.constants[this.index++] = s;
        this.string_table.put(str, new Index(ret));
        return ret;
    }

    public int addUtf8(String n) {
        int ret = this.lookupUtf8(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.index;
        this.constants[this.index++] = new ConstantUtf8(n);
        return ret;
    }

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] cs = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(cs, 0, this.constants, 0, this.index);
        }
    }

    public Constant getConstant(int i) {
        return this.constants[i];
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.index];
        System.arraycopy(this.constants, 0, cs, 0, this.index);
        return new ConstantPool(cs);
    }

    public int getSize() {
        return this.index;
    }

    public int lookupClass(String str) {
        Index index = (Index)this.class_table.get(str.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    public int lookupDouble(double n) {
        int i = 1;
        while (i < this.index) {
            ConstantDouble c;
            if (this.constants[i] instanceof ConstantDouble && (c = (ConstantDouble)this.constants[i]).getBytes() == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupFieldref(String class_name, String field_name, String signature) {
        Index index = (Index)this.cp_table.get(String.valueOf(class_name) + FIELDREF_DELIM + field_name + FIELDREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupFloat(float n) {
        int i = 1;
        while (i < this.index) {
            ConstantFloat c;
            if (this.constants[i] instanceof ConstantFloat && (c = (ConstantFloat)this.constants[i]).getBytes() == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupInteger(int n) {
        int i = 1;
        while (i < this.index) {
            ConstantInteger c;
            if (this.constants[i] instanceof ConstantInteger && (c = (ConstantInteger)this.constants[i]).getBytes() == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupInterfaceMethodref(MethodGen method) {
        return this.lookupInterfaceMethodref(method.getClassName(), method.getMethodName(), method.getMethodSignature());
    }

    public int lookupInterfaceMethodref(String class_name, String method_name, String signature) {
        Index index = (Index)this.cp_table.get(String.valueOf(class_name) + IMETHODREF_DELIM + method_name + IMETHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupLong(long n) {
        int i = 1;
        while (i < this.index) {
            ConstantLong c;
            if (this.constants[i] instanceof ConstantLong && (c = (ConstantLong)this.constants[i]).getBytes() == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupMethodref(MethodGen method) {
        return this.lookupMethodref(method.getClassName(), method.getMethodName(), method.getMethodSignature());
    }

    public int lookupMethodref(String class_name, String method_name, String signature) {
        Index index = (Index)this.cp_table.get(String.valueOf(class_name) + METHODREF_DELIM + method_name + METHODREF_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupNameAndType(String name, String signature) {
        Index index = (Index)this.n_a_t_table.get(String.valueOf(name) + NAT_DELIM + signature);
        return index != null ? index.index : -1;
    }

    public int lookupString(String str) {
        Index index = (Index)this.string_table.get(str);
        return index != null ? index.index : -1;
    }

    public int lookupUtf8(String n) {
        int i = 1;
        while (i < this.index) {
            ConstantUtf8 c;
            if (this.constants[i] instanceof ConstantUtf8 && (c = (ConstantUtf8)this.constants[i]).getBytes().equals(n)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setConstant(int i, Constant c) {
        this.constants[i] = c;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 1;
        while (i < this.index) {
            buf.append(String.valueOf(i) + ")" + this.constants[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    private static class Index {
        int index;

        Index(int i) {
            this.index = i;
        }
    }
}

