/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeConstraint;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class FindPattern
implements Constants {
    private static final int OFFSET = Short.MAX_VALUE;
    private static final int NO_OPCODES = 256;
    private static final String[] patterns = new String[]{"instruction", "branchinstruction", "if_icmp__", "if__", "push", "iload__", "aload__", "fload__", "dload__", "lload__", "istore__", "astore__", "fstore__", "dstore__", "lstore__", "invokeinstruction", "returninstruction", "ifinstruction"};
    private static String[] pattern_map;
    private InstructionList il;
    private String il_string;
    private InstructionHandle[] handles;
    private int match_length;
    private int matched_from;

    static {
        StringBuffer buf = new StringBuffer("(");
        short i = 0;
        while (i < 256) {
            if (Constants.NO_OF_OPERANDS[i] != -1) {
                buf.append(FindPattern.makeChar(i));
                if (i < 255) {
                    buf.append('|');
                }
            }
            i = (short)(i + 1);
        }
        buf.append(')');
        String instruction_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)153, (short)171);
        buf.append('|');
        FindPattern.appendPatterns(buf, (short)198, (short)201);
        buf.append(')');
        String binstruction_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)159, (short)164);
        buf.append(')');
        String if_icmp_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)153, (short)158);
        buf.append(')');
        String if_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)1, (short)20);
        buf.append(')');
        String push_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)26, (short)29);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)21));
        buf.append(')');
        String iload_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)42, (short)45);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)25));
        buf.append(')');
        String aload_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)34, (short)37);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)23));
        buf.append(')');
        String fload_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)38, (short)41);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)24));
        buf.append(')');
        String dload_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)30, (short)33);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)22));
        buf.append(')');
        String lload_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)59, (short)62);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)54));
        buf.append(')');
        String istore_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)75, (short)78);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)58));
        buf.append(')');
        String astore_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)67, (short)70);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)56));
        buf.append(')');
        String fstore_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)71, (short)74);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)57));
        buf.append(')');
        String dstore_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)63, (short)66);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)55));
        buf.append(')');
        String lstore_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)182, (short)185);
        buf.append(')');
        String invoke_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)172, (short)177);
        buf.append(')');
        String return_pattern = buf.toString();
        buf = new StringBuffer("(");
        FindPattern.appendPatterns(buf, (short)153, (short)166);
        buf.append('|');
        buf.append(FindPattern.makeChar((short)198));
        buf.append('|');
        buf.append(FindPattern.makeChar((short)199));
        buf.append(')');
        String if_pattern2 = buf.toString();
        pattern_map = new String[]{instruction_pattern, binstruction_pattern, if_icmp_pattern, if_pattern, push_pattern, iload_pattern, aload_pattern, fload_pattern, dload_pattern, lload_pattern, istore_pattern, astore_pattern, fstore_pattern, dstore_pattern, lstore_pattern, invoke_pattern, return_pattern, if_pattern2};
    }

    public FindPattern(InstructionList il) {
        this.il = il;
        this.reread();
    }

    private static final void appendPatterns(StringBuffer buf, short from, short to) {
        short i = from;
        while (i <= to) {
            buf.append(FindPattern.makeChar(i));
            if (i < to) {
                buf.append('|');
            }
            i = (short)(i + 1);
        }
    }

    public final InstructionList getInstructionList() {
        return this.il;
    }

    public final InstructionHandle[] getMatch() {
        if (this.match_length == -1) {
            throw new ClassGenException("Nothing matched.");
        }
        InstructionHandle[] match = new InstructionHandle[this.match_length];
        System.arraycopy(this.handles, this.matched_from, match, 0, this.match_length);
        return match;
    }

    public final int getMatchLength() {
        return this.match_length;
    }

    private static final String getPattern(String pattern) {
        int i = 0;
        while (i < patterns.length) {
            if (pattern.equals(patterns[i])) {
                return pattern_map[i];
            }
            ++i;
        }
        short i2 = 0;
        while (i2 < 256) {
            if (pattern.equals(Constants.OPCODE_NAMES[i2])) {
                return new String(new char[]{FindPattern.makeChar(i2)});
            }
            i2 = (short)(i2 + 1);
        }
        return null;
    }

    private static final char makeChar(short opcode) {
        return (char)(opcode + Short.MAX_VALUE);
    }

    private static final String makePattern(String pattern) {
        String lower = pattern.toLowerCase();
        StringBuffer buf = new StringBuffer();
        int size = pattern.length();
        boolean in_pattern = false;
        StringBuffer collect = null;
        try {
            int i = 0;
            while (i < size) {
                char ch = lower.charAt(i);
                switch (ch) {
                    case '`': {
                        if (in_pattern) {
                            throw new ClassGenException("` within `' block.");
                        }
                        collect = new StringBuffer();
                        in_pattern = true;
                        break;
                    }
                    case '\'': {
                        if (!in_pattern) {
                            throw new ClassGenException("' without starting `.");
                        }
                        in_pattern = false;
                        String str = collect.toString();
                        String pat = FindPattern.getPattern(str);
                        if (pat == null) {
                            throw new ClassGenException("Unknown instruction pattern: \"" + str + "\"" + " at index " + i);
                        }
                        buf.append(pat);
                        break;
                    }
                    default: {
                        if (in_pattern) {
                            collect.append(ch);
                            break;
                        }
                        buf.append(ch);
                    }
                }
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private static final String pattern2string(String pattern) {
        return FindPattern.pattern2string(pattern, true);
    }

    private static final String pattern2string(String pattern, boolean make_string) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch >= Short.MAX_VALUE) {
                if (make_string) {
                    buf.append(Constants.OPCODE_NAMES[ch - Short.MAX_VALUE]);
                } else {
                    buf.append(ch - Short.MAX_VALUE);
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public final void reread() {
        int size = this.il.getLength();
        char[] buf = new char[size];
        this.handles = this.il.getInstructionHandles();
        this.match_length = -1;
        int i = 0;
        while (i < size) {
            buf[i] = FindPattern.makeChar(this.handles[i].getInstruction().getTag());
            ++i;
        }
        this.il_string = new String(buf);
    }

    public final InstructionHandle search(String pattern) {
        return this.search(pattern, this.il.getStart(), null);
    }

    public final InstructionHandle search(String pattern, CodeConstraint constraint) {
        return this.search(pattern, this.il.getStart(), constraint);
    }

    public final InstructionHandle search(String pattern, InstructionHandle from) {
        return this.search(pattern, from, null);
    }

    public final InstructionHandle search(String pattern, InstructionHandle from, CodeConstraint constraint) {
        String search = FindPattern.makePattern(pattern);
        int start = -1;
        this.matched_from = -1;
        this.match_length = -1;
        int i = 0;
        while (i < this.handles.length) {
            if (this.handles[i] == from) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == -1) {
            throw new ClassGenException("Instruction handle " + from + " not found in instruction list.");
        }
        try {
            RE regex = new RE(search);
            REMatch r = regex.getMatch(this.il_string, start);
            if (r != null) {
                this.matched_from = r.getStartIndex();
                this.match_length = r.getEndIndex() - this.matched_from;
                if (constraint == null || constraint.checkCode(this.getMatch())) {
                    return this.handles[this.matched_from];
                }
            }
        }
        catch (REException e) {
            System.err.println(e);
        }
        return null;
    }

    public final void setInstructionList(InstructionList il) {
        this.il = il;
        this.reread();
    }
}

