/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends Instruction {
    private boolean wide;
    private int n;
    private int c;

    IINC() {
    }

    public IINC(int n, int c) {
        super((short)132, (short)3);
        this.setIndex(n);
        this.setIncrement(c);
        this.n = n;
        this.c = c;
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(this.tag);
        if (this.wide) {
            out.writeShort(this.n);
            out.writeShort(this.c);
        } else {
            out.writeByte(this.n);
            out.writeByte(this.c);
        }
    }

    public final int getIncrement() {
        return this.c;
    }

    public final int getIndex() {
        return this.n;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.wide = wide;
        if (wide) {
            this.length = (short)6;
            this.n = bytes.readUnsignedShort();
            this.c = bytes.readShort();
        } else {
            this.length = (short)3;
            this.n = bytes.readUnsignedByte();
            this.c = bytes.readByte();
        }
    }

    public final void setIncrement(int c) {
        this.c = c;
        this.setWide();
    }

    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.n = n;
        this.setWide();
    }

    private final void setWide() {
        this.wide = this.n > 65535 || Math.abs(this.c) > 127;
        this.length = this.wide ? (short)6 : (short)3;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.n + " " + this.c;
    }
}

