/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class Instruction
implements Constants,
Cloneable,
Serializable {
    protected short length = 1;
    protected short tag = (short)-1;

    Instruction() {
    }

    public Instruction(short tag, short length) {
        this.length = length;
        this.tag = tag;
    }

    private static final String className(short tag) {
        String name = Constants.OPCODE_NAMES[tag].toUpperCase();
        try {
            int len = name.length();
            char ch1 = name.charAt(len - 2);
            char ch2 = name.charAt(len - 1);
            if (ch1 == '_' && ch2 >= '0' && ch2 <= '5') {
                name = name.substring(0, len - 2);
            }
            if (name.equals("ICONST_M1")) {
                name = "ICONST";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return "de.fub.bytecode.generic." + name;
    }

    public int consumeStack() {
        return Constants.CONSUME_STACK[this.tag];
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return this.consumeStack();
    }

    public Instruction copy() {
        Instruction i = null;
        try {
            i = (Instruction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return i;
    }

    void dispose() {
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
    }

    public int getLength() {
        return this.length;
    }

    public short getTag() {
        return this.tag;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
    }

    public int produceStack() {
        return Constants.PRODUCE_STACK[this.tag];
    }

    public int produceStack(ConstantPoolGen cpg) {
        return this.produceStack();
    }

    static final Instruction readInstruction(ByteSequence bytes) throws IOException {
        boolean wide = false;
        short tag = (short)bytes.readUnsignedByte();
        Instruction obj = null;
        if (tag == 196) {
            wide = true;
            tag = (short)bytes.readUnsignedByte();
        }
        if (InstructionConstants.INSTRUCTIONS[tag] != null) {
            return InstructionConstants.INSTRUCTIONS[tag];
        }
        try {
            Class<?> clazz = Class.forName(Instruction.className(tag));
            obj = (Instruction)clazz.newInstance();
            obj.setTag(tag);
            obj.initFromFile(bytes, wide);
        }
        catch (Exception e) {
            throw new ClassGenException(e.toString());
        }
        return obj;
    }

    private void setTag(short tag) {
        this.tag = tag;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool cp) {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return String.valueOf(Constants.OPCODE_NAMES[this.tag]) + "[" + this.tag + "](" + this.length + ")";
        }
        return Constants.OPCODE_NAMES[this.tag];
    }
}

