/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionTargeter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class InstructionHandle
implements Serializable {
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private Vector targeters;
    private Hashtable attributes;
    private static InstructionHandle ih_list = null;
    static /* synthetic */ Class class$de$fub$bytecode$generic$BranchHandle;

    protected InstructionHandle(Instruction i) {
        this.setInstruction(i);
    }

    public void addAttribute(Object key, Object attr) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(3);
        }
        this.attributes.put(key, attr);
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    public void addTargeter(InstructionTargeter t) {
        if (this.targeters == null) {
            this.targeters = new Vector();
        }
        if (!this.targeters.contains(t)) {
            this.targeters.addElement(t);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public Object getAttribute(Object key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    static final InstructionHandle getInstructionHandle(Instruction i) {
        if (ih_list == null) {
            return new InstructionHandle(i);
        }
        InstructionHandle ih = ih_list;
        ih_list = ih.next;
        ih.setInstruction(i);
        return ih;
    }

    public final InstructionHandle getNext() {
        return this.next;
    }

    public int getPosition() {
        return this.i_position;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return null;
        }
        Object[] t = new InstructionTargeter[this.targeters.size()];
        this.targeters.copyInto(t);
        return t;
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.removeAllElements();
        }
    }

    public void removeAttribute(Object key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public void removeTargeter(InstructionTargeter t) {
        this.targeters.removeElement(t);
    }

    public void setInstruction(Instruction i) {
        if (i == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != (class$de$fub$bytecode$generic$BranchHandle != null ? class$de$fub$bytecode$generic$BranchHandle : (class$de$fub$bytecode$generic$BranchHandle = InstructionHandle.class$("de.fub.bytecode.generic.BranchHandle"))) && i instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + i + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = i;
    }

    void setPosition(int pos) {
        this.i_position = pos;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        return String.valueOf(Utility.format(this.i_position, 4, false, ' ')) + ": " + this.instruction.toString(verbose);
    }

    protected int updatePosition(int offset, int max_offset) {
        this.i_position += offset;
        return 0;
    }
}

