/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.FieldOrMethod;
import de.fub.bytecode.generic.Type;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short tag, int index) {
        super(tag, index);
    }

    public int consumeStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        Type[] args = Type.getArgumentTypes(signature);
        int sum = this.tag == 184 ? 0 : 1;
        int n = args.length;
        int i = 0;
        while (i < n) {
            sum += args[i].getSize();
            ++i;
        }
        return sum;
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    public abstract Class[] getExceptions();

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public int produceStack(ConstantPoolGen cpg) {
        return this.getReturnType(cpg).getSize();
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return String.valueOf(Constants.OPCODE_NAMES[this.tag]) + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }
}

