/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.ExceptionConstants;
import de.fub.bytecode.generic.CPInstruction;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.PushInstruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower {
    LDC() {
    }

    public LDC(int index) {
        super((short)19, index);
        this.setSize();
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        if (this.length == 2) {
            out.writeByte(this.index);
        } else {
            out.writeShort(this.index);
        }
    }

    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    public Type getType(ConstantPoolGen cpg) {
        switch (cpg.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
        }
        throw new RuntimeException("Unknown constant type " + this.tag);
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)2;
        this.index = bytes.readUnsignedByte();
    }

    public final void setIndex(int index) {
        super.setIndex(index);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.tag = (short)18;
            this.length = (short)2;
        } else {
            this.tag = (short)19;
            this.length = (short)3;
        }
    }
}

