/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction {
    private int n;
    private short c_tag;
    private short canon_tag;

    LocalVariableInstruction(short canon_tag, short c_tag) {
        this.canon_tag = canon_tag;
        this.c_tag = c_tag;
    }

    protected LocalVariableInstruction(short tag, short c_tag, int n) {
        super(tag, (short)2);
        this.c_tag = c_tag;
        this.canon_tag = tag;
        this.setIndex(n);
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide()) {
            out.writeByte(196);
        }
        out.writeByte(this.tag);
        if (this.length > 1) {
            if (this.wide()) {
                out.writeShort(this.n);
            } else {
                out.writeByte(this.n);
            }
        }
    }

    public final int getIndex() {
        return this.n;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        if (wide) {
            this.n = bytes.readUnsignedShort();
            this.length = (short)4;
        } else if (this.tag >= 21 && this.tag <= 25 || this.tag >= 54 && this.tag <= 58) {
            this.n = bytes.readUnsignedByte();
            this.length = (short)2;
        } else if (this.tag <= 45) {
            this.n = (this.tag - 26) % 4;
            this.length = 1;
        } else {
            this.n = (this.tag - 59) % 4;
            this.length = 1;
        }
    }

    public final void setIndex(int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n >= 0 && n <= 3) {
            this.tag = (short)(this.c_tag + n);
            this.length = 1;
        } else {
            this.tag = this.canon_tag;
            this.length = this.wide() ? (short)4 : (short)2;
        }
    }

    public String toString(boolean verbose) {
        if (this.tag >= 26 && this.tag <= 45 || this.tag >= 59 && this.tag <= 78) {
            return super.toString(verbose);
        }
        return String.valueOf(super.toString(verbose)) + " " + this.n;
    }

    private final boolean wide() {
        return this.n > 255;
    }
}

