/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.ExceptionConstants;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.AllocationInstruction;
import de.fub.bytecode.generic.CPInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.LoadClass;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(int index, short dimensions) {
        super((short)197, index);
        if (dimensions < 1) {
            throw new ClassGenException("Invalid dimensions value: " + dimensions);
        }
        this.dimensions = dimensions;
        this.length = (short)4;
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return this.dimensions;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        out.writeShort(this.index);
        out.writeByte(this.dimensions);
    }

    public final short getDimensions() {
        return this.dimensions;
    }

    public Class[] getExceptions() {
        Class[] cs = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, cs, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length - 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return cs;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.dimensions = bytes.readByte();
        this.length = (short)4;
    }

    public String toString(ConstantPool cp) {
        return String.valueOf(super.toString(cp)) + " " + this.dimensions;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.index + " " + this.dimensions;
    }
}

