/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.ExceptionConstants;
import de.fub.bytecode.generic.AllocationInstruction;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        out.writeByte(this.type);
    }

    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    public final byte getTypecode() {
        return this.type;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        this.length = (short)2;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + Constants.TYPE_NAMES[this.type];
    }
}

