/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.VariableLengthInstruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short tag, int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super(tag, target);
        this.targets = targets;
        int i = 0;
        while (i < targets.length) {
            BranchInstruction.notifyTarget(null, targets[i], this);
            ++i;
        }
        this.match = match;
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    public boolean containsTarget(InstructionHandle ih) {
        if (this.target == ih) {
            return true;
        }
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == ih) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.targets.length) {
            this.targets[i].removeTargeter(this);
            ++i;
        }
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        int i = 0;
        while (i < this.padding) {
            out.writeByte(0);
            ++i;
        }
        this.index = this.getTargetOffset();
        out.writeInt(this.index);
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int[] getMatchs() {
        return this.match;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        int i = 0;
        while (i < this.padding) {
            byte b = bytes.readByte();
            if (b != 0) {
                throw new ClassGenException("Padding byte != 0: " + b);
            }
            ++i;
        }
        this.index = bytes.readInt();
    }

    public void setTarget(int i, InstructionHandle target) {
        BranchInstruction.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer(super.toString(verbose));
        if (verbose) {
            int i = 0;
            while (i < this.match_length) {
                String s = "null";
                if (this.targets[i] != null) {
                    s = this.targets[i].getInstruction().toString();
                }
                buf.append("(" + this.match[i] + ", " + s + " = {" + this.indices[i] + "})");
                ++i;
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    protected int updatePosition(int offset, int max_offset) {
        this.position += offset;
        short old_length = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - old_length;
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.target == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == old_ih) {
                targeted = true;
                this.setTarget(i, new_ih);
            }
            ++i;
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }
}

