/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super((short)170, match, targets, target);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeInt(this.match[0]);
        out.writeInt(this.match[this.match_length - 1]);
        int i = 0;
        while (i < this.match_length) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            out.writeInt(this.indices[i]);
            ++i;
        }
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        int low = bytes.readInt();
        int high = bytes.readInt();
        this.match_length = high - low + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        int i = low;
        while (i <= high) {
            this.match[i - low] = i;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.match_length) {
            this.indices[i2] = bytes.readInt();
            ++i2;
        }
    }
}

