/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.ReferenceType;
import java.util.Vector;

public abstract class Type
implements Constants {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType();
    private static int consumed_chars = 0;

    protected Type(byte t, String s) {
        this.type = t;
        this.signature = s;
    }

    public static Type[] getArgumentTypes(String signature) {
        Vector<Type> vec = new Vector<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatError("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.addElement(Type.getType(signature.substring(index)));
                index += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
        Object[] types = new Type[vec.size()];
        vec.copyInto(types);
        return types;
    }

    public static String getMethodSignature(Type return_type, Type[] arg_types) {
        StringBuffer buf = new StringBuffer("(");
        int length = arg_types == null ? 0 : arg_types.length;
        int i = 0;
        while (i < length) {
            buf.append(arg_types[i].getSignature());
            ++i;
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    public static Type getReturnType(String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatError("Invalid method signature: " + signature);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public byte getType() {
        return this.type;
    }

    public static final Type getType(String signature) throws StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            consumed_chars = 1;
            return BasicType.getType(type);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Type t = Type.getType(signature.substring(dim));
            consumed_chars += dim;
            return new ArrayType(t, dim);
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatError("Invalid signature: " + signature);
        }
        consumed_chars = index + 1;
        return new ObjectType(signature.substring(1, index).replace('/', '.'));
    }

    public String toString() {
        return Utility.signatureToString(this.signature, false);
    }
}

