import java.lang.*;
import java.io.*;

/** Defines a Class Loader that knows how to read a class 
 *  from the local file system.
 */

public abstract class LocalClassLoader extends java.lang.ClassLoader {
  private String directory; 
  public LocalClassLoader (String dir) {
   directory = dir;
  }

  protected Class loadClassFromFile(String name) 
       throws    ClassNotFoundException, IOException {
    FileInputStream f = new FileInputStream(directory + name + ".class");
    int bytecount = f.available();
    byte [] buffer = new byte[(int) bytecount];
    try {
      f.read(buffer);
      Class c = defineClass(name, buffer, 0, bytecount);
      System.out.println("[Loaded " + name + " from " + directory + name + ".class" + " ("+ bytecount + " bytes)]");
      return c;
    }
    catch (java.lang.Exception e) {
      System.out.println("Aborting read: " + e.toString() + " in LocalClassLoader.");
      throw new ClassNotFoundException();
    };
  }
}
