#define isAsm0(c)       (whatIs(c)==ASMFUN0)
#define isAsm1(c)       (whatIs(c)==ASMFUN1)
#define is_undefined(c) (whatIs(c)==ASMDEFAULT)
#define asm_old(c)      (fst(fst(fst(snd(snd(c))))))
#define asm_new(c)      (snd(fst(fst(snd(snd(c))))))
#define asm_default(c)  (snd(snd(snd(snd(c)))))
#define asm_eqFun0(c)   (snd(fst(snd(snd(c)))))
#define asm_eqFun1(c)   (snd(snd(fst(snd(snd(c))))))
#define asm_ordFun(c)   (fst(snd(fst(snd(snd(c))))))
#define asm_changed(c)  (fst(fst(snd(c))))
#define asm_id(c)       (snd(fst(snd(c))))
#define asm_left(c)     (fst(fst(c)))
#define asm_right(c)    (snd(fst(c)))

Cell asmvars_to_update     = NIL;
Int  evaluate_asm          = 1;
StackPtr sp_at_top         = asm_SP;
Int  result_is_evaluated   = 0;
Int  used_steps            = 0;
Int  asmNewInteger         = 0;

INLINE Int  asmWriteFun(Cell, Cell);
INLINE Int  asmWriteFun1(Cell, Cell, Cell, Int);
Cell asmReadFromStdin();


extern Name nameHw;
extern Class classHw;
extern Cell  freeList;

Void asmPrint1(c)
     Cell c;
{
  if (isPair(c)) {
    printf("ap(");
    asmPrint1(fst(c));
    printf(",");
    asmPrint1(snd(c));
    printf(")");
  }
  else switch (whatIs(c)) {
  case NAME: printf("!%s",textToStr(name(c).text));
    /*
    if (name(c).defn) {
      printf("{");
      asmPrint1(name(c).defn);
      printf("}");
    }
    */
    break;
  default: printf(":%d",whatIs(c));
  }
}

Void asmPrint(c)
     Cell c;
{
  asmPrint1(c);
  printf("\n");
}

Void used_funs(e, res)
     Cell e;
     List *res;
{
  if (isPair(e)) {
    used_funs(fst(e), res);
    used_funs(snd(e), res);
  }
  else if (whatIs(e)==NAME) 
    *res = ap(e, *res);
}

INLINE Void asm_add_to_update(asmFun)
     Cell asmFun;
{
    if (asm_changed(asmFun) == nameFalse) {
	asm_changed(asmFun) = nameTrue;
	asmvars_to_update = ap(asmFun, asmvars_to_update);
    }
}

INLINE Cell asm_check(c)
     Cell c;
{
  Int save = evaluate_asm;
  evaluate_asm = 0;
  eval(c);
  evaluate_asm = save;
  if (!isAsm0(whnfHead) && !isAsm1(whnfHead)) {
    ERROR(0) "dynamic function expected" ETHEN
    ERRTEXT  "\n*** expression : " ETHEN ERREXPR(c);
    ERRTEXT  "\n"
    EEND;
  }
  return whnfHead;
}

INLINE Int asm_is_true(func, x, y) 
     Cell func, x, y;
{
  eval(ap(ap(func,x),y));
  if (whnfHead == nameTrue)  return 1;
  if (whnfHead == nameFalse) return 0;
  internal("either true or false expected");
  return 0;
}

INLINE Void asmPrintString(out, e)
     FILE *out;
     Cell e;
{
  eval(e);
  while (whnfHead==nameCons) {
    eval(pop());
    fputc(charOf(whnfHead),out);
    eval(pop());
  }
  fflush(out);
}


Cell strict_eval2(e) 
     Cell e;
{
  Int  args;
  Cell arg, res;

  result_is_evaluated = 0;
  eval(e);
  res = whnfHead;
  args = whnfArgs;
  if (result_is_evaluated) {
    while (args-->0) {
      arg = pop();
      res = ap(res,arg);
    }
  }
  else {
    while (args-->0) {
      arg = pop();
      res = ap(res,strict_eval2(arg));
    }
  }
  return res;
}

INLINE Cell strict_eval(e) 
     Cell e;
{
  Cell res;

  res = strict_eval2(e);
  return res;
}


INLINE Cell eval_value(e)
     Cell e;
{
  Cell res;
  sp_at_top = sp;
  res = strict_eval(e);
  sp_at_top = asm_SP;
  return res;
}

Cell readAsmFun(asmFun) 
     Cell asmFun;
{
  Cell old = asm_old(asmFun);
  Cell fun, arg, res;
  Int  i;

  if (intOf(asm_id(asmFun))==1) old = asm_new(asmFun);
  last_evaluated_asmvar = asmFun;

  i = intOf(asm_id(asmFun));
  if ((i==2) || (i==3)) {
      ERROR(0) "reading output location not allowed" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
  }

  switch (fst(asmFun)) {
  case ASMFUN0: 
    if isNull(old) {
	if (intOf(asm_id(asmFun))==1) {
	    // read location from stdin
	  printf("\n");
          printExp(stdout,asm_name(asmFun));
	  printf(" ? ");
	  fflush(stdout);
          old = asmReadFromStdin();
          asmWriteFun(asmFun, old);
	  return old;
	}
	return ASMDEFAULT;
    }
    else return old;
  case ASMFUN1:
    if (whnfArgs!=1) { 
      ERROR(0) "exactly one argument expected" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
    }
    arg   = pop();
    fun   = strict_eval(ap(asm_ordFun(asmFun),arg));
    while (!isNull(old)) {
      eval(ap(fun,asm_left(old)));
      if (whnfInt==0) {
	return asm_right(old);
      }
      if (whnfInt<0) break;
      old = snd(old);
    }
    last_evaluated_asmvar = asmFun;
    if (i==1) {
      printf("\n");
      printExp(stdout,asm_name(asmFun));
      printf(" ");
      printExp(stdout,arg);
      printf(" ? ");
      fflush(stdout);
      res = asmReadFromStdin();
      asmWriteFun1(asmFun, arg, res, 1);
    }
    else return asm_default(asmFun);
  default: internal("unexpected TAG");
  }
 return NIL;
}

INLINE Int asmWriteFun1(asmFun, arg, value, do_update) 
     Cell asmFun;
     Cell arg;
     Cell value;
     Int  do_update;
{
  Cell n, fun, last;
  Int  insert, i, res;
  Int  same_new_value = 0, value_undefined, right_undefined;

  n = asm_new(asmFun);
  value = eval_value(value);
  value_undefined = is_undefined(value);

  arg    = strict_eval(arg);

  fun    = ap(asm_ordFun(asmFun),arg);
  insert = 1;
  last   = NIL;
  while (!isNull(n)) {
    eval(ap(fun,asm_left(n)));
    res = whnfInt;
    if (res==0) {
      right_undefined = is_undefined(asm_right(n));
      if ((value_undefined == right_undefined) &&
	  (value_undefined || right_undefined ||
	   asm_is_true(asm_eqFun1(asmFun),asm_right(n),value))) 
	same_new_value = 1;
      else { 
	ERROR(0) "inconsistent update" ETHEN
        ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
        ERRTEXT "\n*** expression (new) : " ETHEN ERREXPR(value);
        ERRTEXT "\n*** expression (old) : " ETHEN ERREXPR(asm_right(n));
        ERRTEXT "\n"
	EEND; 
      }
      insert = 0;
      break;
    }
    i = intOf(asm_id(asmFun));
    if (insert && ((i==2) || (i==3))) {
      if (i==3) {
	printf("\n");
	printExp(stdout,asm_name(asmFun));
	printf(" ");
	printExp(stdout,arg);
	printf(" = ");
      }
      asmPrintString(stdout,value);
    }

    if (res<0) {
      if (last==NIL) asm_new(asmFun) = cons(pair(arg,value),n);
      else snd(last) = cons(pair(arg,value),n);
      insert = 0;
      break;
    }
    last = n;
    n    = snd(n);
  }
  if (insert) {
    if (last==NIL) asm_new(asmFun) = cons(pair(arg,value),NIL);
    else snd(last) = cons(pair(arg,value),NIL);
  }
  if (!same_new_value && do_update)  asm_add_to_update(asmFun);
  return same_new_value;
}

primFun(primAsmNewFun0) {
  // String -> Int -> (val -> val -> Bool) -> init -> AsmVar val
  Cell name              = primArg(4);
  Cell kind              = primArg(3);
  Cell eqFunction        = primArg(2);
  Cell initValue         = primArg(1);
  Cell newvalue          = NIL, oldvalue, asmFun;
  Int  save_evaluate_asm = evaluate_asm;

  // printf("new dynamic function: ");
  // ERREXPR(name);
  // printf("\n");

  evaluate_asm = 1;

  initValue = eval_value(initValue);
  oldvalue  = initValue;

  asmFun = ap( ASMFUN0
               , ap( ap(nameFalse, strict_eval(kind))
		     , ap( ap(ap(oldvalue, newvalue), 
			      strict_eval(eqFunction))
			   , ap(name,NIL))
		     )
	       );
  evaluate_asm          = save_evaluate_asm;
  updateRoot(asmFun);
}

primFun(primAsmNewFun1) {
  // String -> Int -> val -> (key -> key -> Int) -> (val -> val -> Bool)
  //  -> [(key,val)] -> AsmVar (key -> val)

  Cell name         = primArg(6);
  Cell kind         = primArg(5);
  Cell defaultValue = primArg(4);
  Cell ordFunction  = primArg(3);
  Cell eqFunction   = primArg(2);
  Cell assoc        = primArg(1);
  Cell asmFun, arg, fun, value, last, n;
  Int  default_undefined, save_evaluate_asm = evaluate_asm;

  // printf("new dynamic function: ");
  // ERREXPR(name);
  // printf("\n");
  evaluate_asm = 1;

  defaultValue      = eval_value(defaultValue);
  default_undefined = is_undefined(defaultValue);

  asmFun = ap(ASMFUN1
	      , ap(ap(nameFalse, strict_eval(kind))
		   , ap(ap(ap(NIL, NIL)
			   , ap(strict_eval(ordFunction),
				strict_eval(eqFunction))
			   )
			, ap(name,defaultValue))
		   )
	      );
  // copy association list to new
  eval(assoc);
  while (whnfHead==nameCons) {
    if (whnfArgs!=2) internal("assoc list expected");
    eval(pop());
    if (!isTuple(whnfHead) || (whnfArgs!=2)) internal("tuple expected");
    arg   = pop();
    value = pop();
    asmWriteFun1(asmFun,arg,value,0);
    eval(pop());
  }
  
  asm_old(asmFun) = asm_new(asmFun);
  asm_new(asmFun) = NIL;

  // delete values which are mapped to default
  n    = asm_old(asmFun);
  last = NIL;
  fun  = ap(eqFunction,defaultValue);
  while (!isNull(n))
    if (is_undefined(asm_right(n)) ||
	(!default_undefined && asm_is_true(fun,asm_right(n)))) {
      // value ist default value => delete
      if (last==NIL) {
	asm_old(asmFun) = snd(n);
	n               = snd(n);
      }
      else {
	snd(last) = snd(n);
	n         = snd(n);
      }
    }
    else {
      last = n;
      n    = snd(n);
    }
  evaluate_asm          = save_evaluate_asm;
  updateRoot(asmFun);
}

primFun(primAsmReadFun) {
  // AsmVar val -> val
  Cell asmFun;

  asmFun = asm_check(primArg(1));
  updateRoot(readAsmFun(asmFun));
}

INLINE Int asmWriteFun(asmFun, value) 
     Cell asmFun;
     Cell value;
{
  Cell n;
  Int  same_new_value = 0, i;

  switch (fst(asmFun)) {
  case ASMFUN0:
    if (whnfArgs!=0) { 
      ERROR(0) "no argument expected" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
    }
    n     = asm_new(asmFun);
    value = eval_value(value);
    if (n==NIL) {
	asm_new(asmFun) = value;
        i = intOf(asm_id(asmFun));
	if ((i==2) || (i==3)) {
	  if (i==3) {
	    printf("\n");
	    printExp(stdout,asm_name(asmFun));
	    printf(" = ");
	  }
	  asmPrintString(stdout,value);
	}
    }
    else {
      if ((is_undefined(value) == is_undefined(n))
	  && (is_undefined(value) || is_undefined(n)
	      || asm_is_true(asm_eqFun0(asmFun),value,n))) 
	same_new_value = 1;
      else { 
	ERROR(0) "inconsistent update" ETHEN
        ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
        ERRTEXT "\n*** expression (new) : " ETHEN ERREXPR(value);
        ERRTEXT "\n*** expression (old) : " ETHEN ERREXPR(n);
        ERRTEXT "\n"
	EEND; 
      }
    }
    if (!same_new_value) asm_add_to_update(asmFun);
    break;
  case ASMFUN1:
    if (whnfArgs!=1) { 
      ERROR(0) "exactly one argument expected" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
    }
    same_new_value = asmWriteFun1(asmFun,pop(),value,1);
    break;
  default: internal("unexpected TAG");
  }
  return same_new_value;
}

primFun(primAsmWriteFun) {
  // AsmVar (key -> val) -> val -> IO ()
  Cell asmFun;
  Cell value  = primArg(2);
  Cell s      = primArg(1);
  eval(s);

  asmFun = asm_check(primArg(3));

  if (intOf(asm_id(asmFun))==1) {
      ERROR(0) "update of input function not allowed" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
  }

  asmWriteFun(asmFun, value);
  updapRoot(ap(mkTuple(2),UNIT),s);
}

primFun(primAsmAssocsFun) {
  // AsmVar (arg -> value) -> [(arg,value)]
  Cell asmFun = primArg(1);
  Cell top, res, old, elem;
  Int  i;

  asmFun = asm_check(asmFun);

  i = intOf(asm_id(asmFun));
  if ((i==2) || (i==3)) {
      ERROR(0) "assocs for output functions not defined" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
  }

  top = res = nameNil;
  if (fst(asmFun)==ASMFUN1) {
    old = asm_old(asmFun);
    while (!isNull(old)) {
      elem = ap(ap(nameCons,
		   ap(ap(mkTuple(2),asm_left(old)), asm_right(old))
		   )
		, nameNil);
      if (top==nameNil) top = elem;
      else snd(res) = elem;
      res = elem;
      old = snd(old);
    }
  }
  else { 
    ERROR(0) "assocs for nullary dynamic functions not defined" ETHEN
    ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
    ERRTEXT "\n"
    EEND; 
  }
  updateRoot(top);
}

primFun(primAsmEmptyDom) {
  // AsmVar (arg -> value) -> Bool
  Cell asmFun = primArg(1);
  Cell old;
  Int  i;

  asmFun = asm_check(asmFun);

  i = intOf(asm_id(asmFun));
  if ((i==2) || (i==3)) {
      ERROR(0) "emptyDom for output functions not defined" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
  }

  if (fst(asmFun)==ASMFUN1) {
    old = asm_old(asmFun);
    if (!isNull(old)) updateRoot(nameFalse);
    else updateRoot(nameTrue);
  }
  else { 
    ERROR(0) "emptyDom for nullary dynamic functions not defined" ETHEN
    ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
    ERRTEXT "\n"
    EEND; 
  }
}

primFun(primAsmRandom) {
  // Int -> Int
  Cell max = primArg(1);
  Int  res;

  eval(max);
  res = rand()%whnfInt;
  updateRoot(mkInt(res));
}

primFun(primAsmNewInteger) {
  // Int
  updatec(mkInt(asmNewInteger));
  asmNewInteger++;
}

primFun(primAsmSetInteger) {
  // Int -> IO ()
  Cell i = primArg(2);
  Cell s = primArg(1);

  eval(s);
  eval(i);
  asmNewInteger = whnfInt;
  updapRoot(ap(mkTuple(2),UNIT),s);
}

primFun(primAsmDefault) {
  // () -> a
  updateRoot(ASMDEFAULT);
}

primFun(primAsmInDom) {
  // key -> AsmVar (key -> value) -> Bool
  Cell key    = primArg(2);
  Cell asmFun = primArg(1);
  Cell old, fun;
  Int  i;

  asmFun = asm_check(asmFun);
  old    = asm_old(asmFun);

  i = intOf(asm_id(asmFun));
  if ((i==2) || (i==3)) {
      ERROR(0) "inDom for output functions not defined" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
  }

  switch (fst(asmFun)) {
  case ASMFUN0:
    ERROR(0) "inDom for nullary dynamic functions not defined" ETHEN
    ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
    ERRTEXT "\n"
    EEND; 
  case ASMFUN1:
    if (whnfArgs!=0) { 
      ERROR(0) "no argument expected" ETHEN
      ERRTEXT "\n*** dynamic function : " ETHEN ERREXPR(asm_name(asmFun));
      ERRTEXT "\n"
      EEND; 
    }
    fun = strict_eval(ap(asm_ordFun(asmFun),key));
    while (!isNull(old)) {
      eval(ap(fun,asm_left(old)));
      if (whnfInt==0) {
        updateRoot(nameTrue);
	return;
      }
      if (whnfInt<0) break;
      old = snd(old);
    }
    updateRoot(nameFalse);
    return;
  default: internal("unexpected TAG");
  }
}

primFun(primAsmStrictEval) {
  // a -> IO a
  Cell a = primArg(2);
  Cell s = primArg(1);
  Cell erg;

  eval(s);
  erg = strict_eval(a);
  updapRoot(ap(mkTuple(2),erg),s);
}

Cell asmCopyExpr(e)
     Cell e;
{ 
  Cell x;
  if ((whatIs(e)==AP) && (fst(e)!=ASMFUN0) && (fst(e)!=ASMFUN1)) {
    if ((x = heapTopASM[e])) return x;
    heapListASM = ap(e,heapListASM);
    heapTopASM[e] = x = ap(NIL,NIL);
    fst(x) = asmCopyExpr(fst(e));
    snd(x) = asmCopyExpr(snd(e));
    return x;
  }
  else return e;
}

primFun(primAsmCopyExpr) {
  // a -> a
  Cell a = primArg(1);
  Cell old;

  heapListASM = NIL;
  a = asmCopyExpr(a);

  while (heapListASM!=NIL) {
    heapTopASM[fst(heapListASM)] = 0;
    old         = heapListASM;
    heapListASM = snd(heapListASM);
    snd(old)    = freeList;
    freeList    = old;
  }
  updatec(a);
}


primFun(primAsmUpdateFun) {
  // IO Bool
  // returns true if state changed
  Cell s = primArg(1);
  Cell n, asmFun, lold, lnew, last;
  Int  default_defined, state_changed = 0;
  Cell dflt, eqFun, ordFun;

  eval(s);
  while (asmvars_to_update!=NIL) {
    asmFun              = fst(asmvars_to_update);
    asmvars_to_update   = snd(asmvars_to_update);

    // asmFun              = asm_check(asmFun);
    asm_changed(asmFun) = nameFalse;

    switch (fst(asmFun)) {
    case ASMFUN0:
      n = asm_new(asmFun);
      if (n!=NIL) {
        lold = asm_old(asmFun);
	if (1 || (!state_changed && 
            ( (is_undefined(n) != is_undefined(lold)) ||
	      (!is_undefined(n) && 
               (!asm_is_true(asm_eqFun0(asmFun),lold,n))))))
	  state_changed = 1;
	asm_old(asmFun) = n;
      }
      asm_new(asmFun) = NIL;
      break;
    case ASMFUN1: 
      lold  = asm_old(asmFun);
      lnew  = asm_new(asmFun);
      last  = NIL;
      dflt  = asm_default(asmFun);
      eqFun = asm_eqFun1(asmFun);
      ordFun= asm_ordFun(asmFun);
      default_defined = !is_undefined(dflt);

      while (!isNull(lnew)) {
	while (!isNull(lold) && 
	       (eval(ap(ap(ordFun,
			   asm_left(lold)), 
			asm_left(lnew))),whnfInt<0)) {
	  last = lold;
	  lold = snd(lold);
	}
	if (!isNull(lold) && (whnfInt==0)) {
	  // new value found in old-list
	  if (0 && (!is_undefined(asm_right(lnew)) &&
	      (asm_is_true(eqFun,
			  asm_right(lold),asm_right(lnew))))) ;
	  else { // values are different
	    state_changed = 1;
	    if (is_undefined(asm_right(lnew)) ||
		(default_defined &&
		 asm_is_true(eqFun, dflt, asm_right(lnew)))) {
	      // new value is default value => delete
	      if (last==NIL) {
		asm_old(asmFun) = snd(lold);
		lold            = snd(lold);
	      }
	      else {
		snd(last)       = snd(lold);
		lold            = snd(lold);
	      }
	    }
	    else {
	      // new value is not default value => replace
	      asm_right(lold)  = asm_right(lnew);
	    }
	  }
	}
	else {
	  // new value is not in old-list
	  if (is_undefined(asm_right(lnew)) ||
	      (default_defined &&
	       (asm_is_true(eqFun, dflt, asm_right(lnew))))) ;
	  else { // add value to old-list
	    state_changed = 1;
	    if (last==NIL) {
	      asm_old(asmFun) = cons(fst(lnew),lold);
	      last            = asm_old(asmFun);
	    }
	    else {
	      snd(last) = cons(fst(lnew),lold);
	      last      = snd(last);
	    }
	  }
	}
	lnew = snd(lnew);
      }
      asm_new(asmFun) = NIL;
      break;
    default: internal("unexpected TAG");
    }
  }
  if (state_changed) used_steps++;
  updapRoot(ap(mkTuple(2),state_changed ? nameTrue : nameFalse),s);
}

Cell asmReadFromStdin() {
  Int c = 0;
  Cell res = NIL, r = NIL;

  normalTerminal();
  do {
    if (c) {
      if (isNull(r)) {
	r   = ap(ap(nameCons,mkChar(c)),nameNil);
	res = r;
      }
      else {
	snd(r) = ap(ap(nameCons,mkChar(c)),nameNil);
	r      = snd(r);
      }
    }
    c = readTerminalChar();
  } while ((c!=EOF) && (c!='\n'));

  return isNull(res) ? nameNil : res;
}

Void determineDynamic(nm)
     Name nm;
{
  List l;
  if (name(nm).asmvar_kind!=ASM_NOTHING) return;
  if (name(nm).primDef) return;

  name(nm).asmvar_kind = ASM_STATIC;
  l = name(nm).used_funs;
  while (l!=NIL) {
    determineDynamic(fst(l));
    if ((name(fst(l)).asmvar_kind==ASM_DYNAMIC) 
	|| (name(fst(l)).asmvar_kind==ASM_DYNAMIC_FUNCTION)) {
      name(nm).asmvar_kind = ASM_DYNAMIC;
      //      printf("function %s is dynamic\n",textToStr(name(nm).text));
      name(nm).used_funs = NIL;
      return;
    }
    l = snd(l);
  }
  name(nm).used_funs = NIL;
}

Cell selectOfList(n,l)
     Int n;
     List l;
{
  while (n-->0) l = snd(l);
  return fst(l);
}

Void determineDynamicFunctions()
{
  Name  nm;
  Class c;
  List  l, l2;
  Int   i;
  

  for (c=CLASSMIN; c<classHw; c++) {
    l = class(c).defaults;
    for (i=0;l!=NIL;i++, l = snd(l))
      if (fst(l))
	used_funs(fst(l), 
		  &(name(selectOfList(i,class(c).members)).used_funs));

    l = class(c).instances;
    while (l!=NIL) {
      l2 = inst(fst(l)).implements;
      for (i=0;l2!=NIL;i++,l2=snd(l2))
	if (fst(l2))
	used_funs(fst(l2), 
		  &(name(selectOfList(i,class(c).members)).used_funs));
      l = snd(l);
    }
  }

  for (nm=NAMEMIN; nm<nameHw; ++nm) {
    if (nonNull(name(nm).type)) determineDynamic(nm);
    name(nm).used_funs = NIL;
  }
}
