package de.fub.bytecode.generic;

/** 
 * ALOAD - Load reference from local variable
 * <PRE>Stack ... -&gt; ..., objectref</PRE>
 *
 * @version $Id: ALOAD.java,v 1.5 2000/04/19 08:47:00 dahm Exp $
 * @author  <A HREF="http://www.inf.fu-berlin.de/~dahm">M. Dahm</A>
 */
public class ALOAD extends LocalVariableInstruction implements PushInstruction {
  /**
   * Empty constructor needed for the Class.newInstance() statement in
   * Instruction.readInstruction(). Not to be used otherwise.
   */
  ALOAD() {
    super(ALOAD, ALOAD_0);
  }

  /** Load reference from local variable
   * @param n index of local variable
   */
  public ALOAD(int n) {
    super(ALOAD, ALOAD_0, n);
  }
}

