package de.fub.bytecode.generic;

/**
 * Super class for instructions dealing with array access such as IALOAD.
 *
 * @version $Id: ArrayInstruction.java,v 1.3 1999/09/09 07:42:45 dahm Exp $
 * @author  <A HREF="http://www.inf.fu-berlin.de/~dahm">M. Dahm</A>
 */
public abstract class ArrayInstruction extends Instruction implements ExceptionThrower {
  /**
   * Empty constructor needed for the Class.newInstance() statement in
   * Instruction.readInstruction(). Not to be used otherwise.
   */
  ArrayInstruction() {}

  /**
   * @param tag opcode of instruction
   */
  protected ArrayInstruction(short tag) {
    super(tag, (short)1);
  }

  public Class[] getExceptions() { return EXCS_ARRAY_EXCEPTION; }
}

