#include "ap.h"


// The bigint functions
// Bigints are simply arrays of unsigned integers, they can be seen as
// base-2^32 numbers. Arithmetic on them is quite fast.
// The least significant word is stored first.

// rawtype bigadd (rawtype *d, rawtype *s, size_t n, size_t c)
// rawtype bigsub (rawtype *d, rawtype *s, size_t n, size_t c)
// rawtype bigmul (rawtype *d, rawtype *s, rawtype f, size_t n)
// rawtype bigdiv (rawtype *d, rawtype *s, rawtype f, size_t n)
// int bigshr (rawtype *d, rawtype *s, size_t n)
// int bigcmp (rawtype *d, rawtype *s, size_t n)

asm ("
    .globl _bigadd
    .globl _bigsub
    .globl _bigmul
    .globl _bigdiv
    .globl _bigshr
    .globl _bigcmp

.align 5
_bigadd:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx

    clc

    jecxz bigaddcarry

    leal (%esi, %ecx, 4), %esi
    leal (%edi, %ecx, 4), %edi
    negl %ecx

    clc

    bigaddloop:
    movl (%esi, %ecx, 4), %eax
    adcl %eax, (%edi, %ecx, 4)
    incl %ecx
    jnz bigaddloop

    bigaddcarry:

    jnc bigaddend

    movl 28(%esp), %ecx

    jecxz bigaddend

    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigaddcarryloop:
    adcl $0, (%edi, %ecx, 4)
    jnc bigaddend
    incl %ecx
    jnz bigaddcarryloop

    bigaddend:

    movl $0, %eax
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigsub:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx

    clc

    jecxz bigsubcarry

    leal (%esi, %ecx, 4), %esi
    leal (%edi, %ecx, 4), %edi
    negl %ecx

    clc

    bigsubloop:
    movl (%esi, %ecx, 4), %eax
    sbbl %eax, (%edi, %ecx, 4)
    incl %ecx
    jnz bigsubloop

    bigsubcarry:

    jnc bigsubend

    movl 28(%esp), %ecx

    jecxz bigsubend

    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigsubcarryloop:
    sbbl $0, (%edi, %ecx, 4)
    jnc bigsubend
    incl %ecx
    jnz bigsubcarryloop

    bigsubend:

    movl $0, %eax
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigmul:
    pushl %ebx
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 36(%esp), %ecx

    xorl %ebx, %ebx

    jecxz bigmulend

    leal (%edi, %ecx, 4), %edi
    leal (%esi, %ecx, 4), %esi
    negl %ecx

    bigmulloop:
    movl 32(%esp), %eax
    mull (%esi, %ecx, 4)
    add %ebx, %eax
    adc $0, %edx
    movl %eax, (%edi, %ecx, 4)
    movl %edx, %ebx
    incl %ecx
    jnz bigmulloop

    bigmulend:

    movl %ebx, %eax

    popl %edi
    popl %esi
    popl %edx
    popl %ecx
    popl %ebx

    ret

.align 5
_bigdiv:
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi

    movl 20(%esp), %edi
    movl 24(%esp), %esi
    movl 32(%esp), %ecx

    xorl %edx, %edx

    jecxz bigdivend

    movl -4(%esi, %ecx, 4), %eax
    cmpl 28(%esp), %eax
    jae bigdivloop
    movl $0, -4(%edi, %ecx, 4)
    decl %ecx
    movl %eax, %edx

    jecxz bigdivend

    bigdivloop:
    movl -4(%esi, %ecx, 4), %eax
    divl 28(%esp)
    movl %eax, -4(%edi, %ecx, 4)
    decl %ecx
    jnz bigdivloop

    bigdivend:

    movl %edx, %eax

    popl %edi
    popl %esi
    popl %edx
    popl %ecx

    ret

.align 5
_bigshr:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx

    clc

    jecxz bigshrend

    bigshrloop:
    movl -4(%esi, %ecx, 4), %eax
    rcrl $1, %eax
    movl %eax, -4(%edi, %ecx, 4)
    decl %ecx
    jnz bigshrloop

    bigshrend:

    movl $0, %eax
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigcmp:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx

    jecxz bigcmpend

    subl $4, %edi
    subl $4, %esi

    bigcmploop:
    movl (%edi, %ecx, 4), %eax
    cmpl (%esi, %ecx, 4), %eax
    jb bigcmpb
    ja bigcmpa
    decl %ecx
    jnz bigcmploop

    bigcmpend:
    xor %eax, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

    bigcmpb:
    movl $-1, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

    bigcmpa:
    movl $1, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret
");
