#include "ap.h"


// The baseint functions
// Baseints are basically bigints, but the base is not the rawtype maximum, but Base

// rawtype baseadd (rawtype *dest, rawtype *src1, rawtype *src2, size_t len, rawtype carry)
// rawtype basesub (rawtype *dest, rawtype *src1, rawtype *src2, size_t len, rawtype carry)
// rawtype basemuladd (rawtype *dest, rawtype *src1, rawtype *src2, rawtype src3, size_t len, rawtype carry)
// rawtype basediv (rawtype *dest, rawtype *src1, rawtype src2, size_t len, rawtype carry)

// basediv1:     %edi:%ebx:%ebp:%esi / %eax:%edx -> quot = %ebx:%ebp, rem = %eax:%edx

asm ("
    .globl _baseadd
    .globl _basesub
    .globl _basemuladd
    .globl _basediv

.align 5
_baseadd:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 36(%esp), %ecx
    movl 40(%esp), %eax

    testl %ecx, %ecx
    jz baseaddend

    baseaddloop:
    movl -8(%esi, %ecx, 8), %edx
    movl -4(%esi, %ecx, 8), %ebp
    addl %eax, %edx
    movl $0, %eax
    adcl $0, %ebp

    movl 32(%esp), %ebx
    testl %ebx, %ebx
    jz baseaddloopnosrc2
    addl -8(%ebx, %ecx, 8), %edx
    movl -4(%ebx, %ecx, 8), %eax
    adcl %eax, %ebp
    movl $0, %eax
    adcl %eax, %eax
    baseaddloopnosrc2:

    movl _Base, %ebx
    subl %ebx, %edx
    movl _Base+4, %esi
    sbbl %esi, %ebp
    sbbl $0, %eax
    decl %ecx

    andl %eax, %ebx
    andl %eax, %esi
    incl %eax
    addl %ebx, %edx
    adcl %esi, %ebp

    testl %ecx, %ecx
    movl 28(%esp), %esi
    movl %edx, (%edi, %ecx, 8)
    movl %ebp, 4(%edi, %ecx, 8)
    jnz baseaddloop

    baseaddend:

    xorl %edx, %edx

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret

.align 5
_basesub:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 36(%esp), %ecx
    movl 40(%esp), %eax

    testl %ecx, %ecx
    jz basesubend

    basesubloop:
    xorl %edx, %edx
    xorl %ebp, %ebp

    testl %esi, %esi
    jz basesubloopnosrc1
    movl -8(%esi, %ecx, 8), %edx
    movl -4(%esi, %ecx, 8), %ebp
    basesubloopnosrc1:

    xorl %esi, %esi
    movl 32(%esp), %ebx

    testl %ebx, %ebx
    jz basesubloopnosrc2
    addl -8(%ebx, %ecx, 8), %eax
    movl -4(%ebx, %ecx, 8), %esi
    adcl $0, %esi
    basesubloopnosrc2:

    subl %eax, %edx
    sbbl %esi, %ebp

    movl _Base, %ebx
    sbbl %eax, %eax
    movl _Base+4, %esi

    andl %eax, %ebx
    andl %eax, %esi
    negl %eax
    addl %ebx, %edx
    adcl %esi, %ebp

    movl 28(%esp), %esi
    movl %edx, -8(%edi, %ecx, 8)
    movl %ebp, -4(%edi, %ecx, 8)
    decl %ecx
    jnz basesubloop

    basesubend:

    xorl %edx, %edx

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret

.align 5
_basediv1:
    pushl %edi
    pushl %ebx
    pushl %eax
    pushl %edx 

    movl %ebp, _tmpll
    xorl $0x80000000, %esi
    movl %esi, _tmpll+4
    xorl $0x80000000, %ebx
    fildq _tmpll
    movl %edi, _tmpll
    movl %ebx, _tmpll+4
    fildq _tmpll
    fxch %st(1)
    fadd %st(3), %st
    fxch %st(1)
    fadd %st(3), %st
    fxch %st(1)
    fmul %st(4), %st
    faddp %st, %st(1)
    fmul %st(1), %st
    fsub %st(2), %st
    fistpq _tmpll
    movl %ebp, %ebx
    movl _tmpll+4, %edx
    xorl $0x80000000, %edx
    xorl %ebp, %ebp
    movl %edx, _tmpll+4

    movl 4(%esp), %eax; mull _tmpll
    movl %eax, %esi; movl %edx, %edi
    movl 4(%esp), %eax; mull _tmpll+4
    addl %eax, %edi; adcl %edx, %ebp
    movl (%esp), %eax; mull _tmpll
    addl %eax, %edi; adcl %edx, %ebp
    movl (%esp), %eax; imull _tmpll+4, %eax
    addl %eax, %ebp

    movl 12(%esp), %eax
    subl %esi, %eax
    movl 8(%esp), %edx
    sbbl %edi, %edx
    movl 4(%esp), %esi
    sbbl %ebp, %ebx
    movl (%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    movl %ebx, %ebp
    sarl $31, %ebp
    andl %ebp, %esi
    andl %ebp, %edi
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    adcl $0, %ebx
    notl %ebp
    movl _tmpll+4, %edi
    subl %ebp, %esi
    sbbl %ebp, %edi
    movl %esi, _tmpll
    movl %edi, _tmpll+4
    movl 4(%esp), %esi
    movl (%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    movl %ebx, %ebp
    sarl $31, %ebp
    andl %ebp, %esi
    andl %ebp, %edi
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    adcl $0, %ebx
    notl %ebp
    movl _tmpll+4, %edi
    subl %ebp, %esi
    sbbl %ebp, %edi
    movl %esi, _tmpll
    movl %edi, %ebp
    movl 4(%esp), %esi
    movl (%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    andl %ebx, %esi
    andl %ebx, %edi
    notl %ebx
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    subl %ebx, %esi
    sbbl %ebx, %ebp

    addl $16, %esp
    movl %esi, %ebx

    ret

.align 5
_basemuladd:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl _Base, %eax
    movl _Base+4, %edx
    cmpl $0x80000000, %edx
    jne basemuladdnofast
    testl %eax, %eax
    jz basemuladdfast
    basemuladdnofast:
    xorl $0x80000000, %edx
    movl %eax, _tmpll
    movl %edx, _tmpll+4
    fildq _tmpll
    flds _c2p63
    flds _c2p64
    fxch %st(2)
    fadd %st(1), %st
    fdivrs _c1one
    basemuladdfast:

    movl 28(%esp), %esi
    movl 44(%esp), %ecx
    movl 48(%esp), %eax
    movl 52(%esp), %edx

    testl %ecx, %ecx
    jz basemuladdend

    basemuladdloop:
    movl -8(%esi, %ecx, 8), %eax
    mull 36(%esp)
    movl %eax, %edi
    movl %edx, %ebx
    movl -4(%esi, %ecx, 8), %eax
    mull 36(%esp)
    xorl %ebp, %ebp
    addl %eax, %ebx
    adcl %edx, %ebp
    movl -8(%esi, %ecx, 8), %eax
    mull 40(%esp)
    addl %eax, %ebx
    movl -4(%esi, %ecx, 8), %eax
    adcl %edx, %ebp
    movl $0, %esi
    adcl $0, %esi
    mull 40(%esp)
    decl %ecx
    addl %eax, %ebp
    adcl %edx, %esi

    movl 48(%esp), %eax
    movl 52(%esp), %edx
    addl %eax, %edi
    adcl %edx, %ebx
    adcl $0, %ebp
    adcl $0, %esi

    movl 32(%esp), %eax
    testl %eax, %eax
    jz basemuladdloopnosrc2
    addl (%eax, %ecx, 8), %edi
    movl 4(%eax, %ecx, 8), %edx
    adcl %edx, %ebx
    adcl $0, %ebp
    adcl $0, %esi
    basemuladdloopnosrc2:

    movl _Base, %eax
    movl _Base+4, %edx

    cmpl $0x80000000, %edx
    jne basemuladdloopnofast
    testl %eax, %eax
    jnz basemuladdloopnofast
    movl %edi, %eax
    movl %ebx, %edx
    shrdl $31, %ebp, %ebx
    shrdl $31, %esi, %ebp
    andl $0x7FFFFFFF, %edx
    jmp basemuladdloopfast
    basemuladdloopnofast:
    call _basediv1
    basemuladdloopfast:

    movl 24(%esp), %edi
    movl 28(%esp), %esi

    movl %ebx, 48(%esp)
    movl %ebp, 52(%esp)

    movl %eax, (%edi, %ecx, 8)
    movl %ebx, %eax
    movl %edx, 4(%edi, %ecx, 8)
    movl %ebp, %edx

    testl %ecx, %ecx
    jnz basemuladdloop

    basemuladdend:

    movl _Base, %ebx
    movl _Base+4, %ecx
    cmpl $0x80000000, %ecx
    jne basemuladdnofastend
    testl %ebx, %ebx
    jz basemuladdfastend
    basemuladdnofastend:
    fstp %st
    fstp %st
    fstp %st
    basemuladdfastend:

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret

.align 5
_basediv:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 36(%esp), %edx
    movl 32(%esp), %eax
    xorl $0x80000000, %edx
    movl %eax, _tmpll
    movl %edx, _tmpll+4
    fildq _tmpll
    flds _c2p63
    flds _c2p64
    fxch %st(2)
    fadd %st(1), %st
    fdivrs _c1one

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 40(%esp), %ecx
    movl 44(%esp), %eax
    movl 48(%esp), %edx

    testl %ecx, %ecx
    jz basedivend

    leal (%edi, %ecx, 8), %edi
    testl %esi, %esi
    movl %edi, 24(%esp)
    jz basedivnosrc1
    leal (%esi, %ecx, 8), %esi
    movl %esi, 28(%esp)
    basedivnosrc1:
    negl %ecx

    basedivloop:
    movl _Base+4, %edx
    movl _Base, %eax
    cmpl $0x80000000, %edx
    jne basedivloopnofast
    testl %eax, %eax
    jnz basedivloopnofast
    movl 44(%esp), %ebp
    movl 48(%esp), %esi
    xorl %edi, %edi
    xorl %ebx, %ebx
    shrdl $1, %ebp, %ebx
    shrdl $1, %esi, %ebp
    shrl $1, %esi
    jmp basedivloopfast
    basedivloopnofast:
    mull 44(%esp)
    movl %eax, %edi
    movl %edx, %ebx
    movl _Base+4, %eax
    mull 44(%esp)
    xorl %ebp, %ebp
    addl %eax, %ebx
    adcl %edx, %ebp
    movl _Base, %eax
    mull 48(%esp)
    addl %eax, %ebx
    movl _Base+4, %eax
    adcl %edx, %ebp
    movl $0, %esi
    adcl $0, %esi
    mull 48(%esp)
    addl %eax, %ebp
    adcl %edx, %esi
    basedivloopfast:

    movl 28(%esp), %eax
    testl %eax, %eax
    jz basedivloopnosrc1
    addl (%eax, %ecx, 8), %edi
    movl 4(%eax, %ecx, 8), %edx
    adcl %edx, %ebx
    adcl $0, %ebp
    adcl $0, %esi
    basedivloopnosrc1:

    movl 32(%esp), %eax
    movl 36(%esp), %edx

    call _basediv1

    movl 24(%esp), %edi
    movl 28(%esp), %esi

    movl %eax, 44(%esp)
    movl %edx, 48(%esp)

    movl %ebx, (%edi, %ecx, 8)
    movl %ebp, 4(%edi, %ecx, 8)

    incl %ecx
    jnz basedivloop

    basedivend:

    fstp %st
    fstp %st
    fstp %st

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret
");
