#include "ap.h"


// The bigint functions
// Bigints are simply arrays of unsigned integers, they can be seen as
// base-2^64 numbers. Arithmetic on them is quite fast.
// The least significant word is stored first.

// rawtype bigadd (rawtype *d, rawtype *s, size_t n, size_t c)
// rawtype bigsub (rawtype *d, rawtype *s, size_t n, size_t c)
// rawtype bigmul (rawtype *d, rawtype *s, rawtype f, size_t n)
// rawtype bigdiv (rawtype *d, rawtype *s, rawtype f, size_t n)
// int bigshr (rawtype *d, rawtype *s, size_t n)
// int bigcmp (rawtype *d, rawtype *s, size_t n)

long long tmpll;
float c1one = 1.0;
float c2p63 = 9223372036854775808.0;            // 2^63
float c2p64 = 18446744073709551616.0;           // 2^64

asm ("
    .globl _bigadd
    .globl _bigsub
    .globl _bigmul
    .globl _bigdiv
    .globl _bigshr
    .globl _bigcmp

.align 5
_bigadd:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx
    addl %ecx, %ecx

    jz bigaddcarry

    leal (%esi, %ecx, 4), %esi
    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigaddloop:
    movl (%esi, %ecx, 4), %eax
    adcl %eax, (%edi, %ecx, 4)
    incl %ecx
    jnz bigaddloop

    bigaddcarry:

    jnc bigaddend

    movl 28(%esp), %ecx
    addl $0x80000000, %ecx
    addl %ecx, %ecx

    jz bigaddend

    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigaddcarryloop:
    adcl $0, (%edi, %ecx, 4)
    jnc bigaddend
    incl %ecx
    jnz bigaddcarryloop

    bigaddend:

    movl $0, %eax
    movl $0, %edx
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigsub:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx
    addl %ecx, %ecx

    jz bigsubcarry

    leal (%esi, %ecx, 4), %esi
    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigsubloop:
    movl (%esi, %ecx, 4), %eax
    sbbl %eax, (%edi, %ecx, 4)
    incl %ecx
    jnz bigsubloop

    bigsubcarry:

    jnc bigsubend

    movl 28(%esp), %ecx
    addl $0x80000000, %ecx
    addl %ecx, %ecx

    jz bigsubend

    leal (%edi, %ecx, 4), %edi
    notl %ecx
    incl %ecx

    bigsubcarryloop:
    sbbl $0, (%edi, %ecx, 4)
    jnc bigsubend
    incl %ecx
    jnz bigsubcarryloop

    bigsubend:

    movl $0, %eax
    movl $0, %edx
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigmul:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 40(%esp), %ecx
    xorl %ebx, %ebx
    xorl %ebp, %ebp
    addl %ecx, %ecx

    jz bigmulend

    leal (%edi, %ecx, 4), %edi
    leal (%esi, %ecx, 4), %esi
    negl %ecx

    bigmulloop:
    movl 32(%esp), %eax
    mull (%esi, %ecx, 4)
    addl %ebx, %eax
    movl $0, %ebx
    adcl %edx, %ebp
    movl (%esi, %ecx, 4), %edx
    adcl %ebx, %ebx
    movl %eax, (%edi, %ecx, 4)

    movl 36(%esp), %eax
    mull %edx
    addl %ebp, %eax
    movl %ebx, %ebp
    adcl %edx, %ebp
    movl %eax, %ebx

    incl %ecx
    jnz bigmulloop

    bigmulend:

    movl %ebx, %eax
    movl %ebp, %edx

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret

.align 5
_bigdiv:
    pushl %ebx
    pushl %ecx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 36(%esp), %edx
    movl 32(%esp), %eax
    xorl $0x80000000, %edx
    movl %eax, _tmpll
    movl %edx, _tmpll+4
    fildq _tmpll
    flds _c2p63
    flds _c2p64
    fxch %st(2)
    fadd %st(1), %st

    movl 24(%esp), %edi
    movl 28(%esp), %esi
    movl 40(%esp), %ecx

    fdivrs _c1one

    xorl %eax, %eax
    xorl %edx, %edx

    testl %ecx, %ecx
    jz bigdivend

    movl -8(%esi, %ecx, 8), %ebx
    movl -4(%esi, %ecx, 8), %ebp
    cmpl 36(%esp), %ebp
    ja bigdivloop
    jb bigdivsub
    cmpl 32(%esp), %ebx
    jae bigdivloop
    bigdivsub:
    movl %eax, -8(%edi, %ecx, 8)
    movl %eax, -4(%edi, %ecx, 8)
    movl %ebx, %eax
    movl %ebp, %edx
    decl %ecx

    jz bigdivend

    bigdivloop:
    movl %eax, _tmpll
    xorl $0x80000000, %edx
    movl %edx, _tmpll+4
    fildq _tmpll
    movl -8(%esi, %ecx, 8), %ebx
    movl -4(%esi, %ecx, 8), %ebp
    movl %ebx, _tmpll
    xorl $0x80000000, %ebp
    movl %ebp, _tmpll+4
    fildq _tmpll
    fxch %st(1)
    fadd %st(3), %st
    fxch %st(1)
    fadd %st(3), %st
    fxch %st(1)
    fmul %st(4), %st
    faddp %st, %st(1)
    fmul %st(1), %st
    fsub %st(2), %st
    fistpq _tmpll
    movl %eax, %ebx
    movl _tmpll+4, %edx
    xorl $0x80000000, %edx
    xorl %ebp, %ebp
    movl %edx, _tmpll+4

    movl 32(%esp), %eax; mull _tmpll
    movl %eax, %esi; movl %edx, %edi
    movl 32(%esp), %eax; mull _tmpll+4
    addl %eax, %edi; adcl %edx, %ebp
    movl 36(%esp), %eax; mull _tmpll
    addl %eax, %edi; adcl %edx, %ebp
    movl 36(%esp), %eax; imull _tmpll+4, %eax
    movl %esi, %edx
    movl 28(%esp), %esi
    addl %eax, %ebp

    movl -8(%esi, %ecx, 8), %eax
    subl %edx, %eax
    movl -4(%esi, %ecx, 8), %edx
    sbbl %edi, %edx
    movl 32(%esp), %esi
    sbbl %ebp, %ebx
    movl 36(%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    movl %ebx, %ebp
    sarl $31, %ebp
    andl %ebp, %esi
    andl %ebp, %edi
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    adcl $0, %ebx
    notl %ebp
    movl _tmpll+4, %edi
    subl %ebp, %esi
    sbbl %ebp, %edi
    movl %esi, _tmpll
    movl %edi, _tmpll+4
    movl 32(%esp), %esi
    movl 36(%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    movl %ebx, %ebp
    sarl $31, %ebp
    andl %ebp, %esi
    andl %ebp, %edi
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    adcl $0, %ebx
    notl %ebp
    movl _tmpll+4, %edi
    subl %ebp, %esi
    sbbl %ebp, %edi
    movl %esi, _tmpll
    movl %edi, %ebp
    movl 32(%esp), %esi
    movl 36(%esp), %edi

    subl %esi, %eax
    sbbl %edi, %edx
    sbbl $0, %ebx
    andl %ebx, %esi
    andl %ebx, %edi
    notl %ebx
    addl %esi, %eax
    adcl %edi, %edx
    movl _tmpll, %esi
    movl 24(%esp), %edi
    subl %ebx, %esi
    sbbl %ebx, %ebp

    movl %esi, -8(%edi, %ecx, 8)
    movl %ebp, -4(%edi, %ecx, 8)

    movl 28(%esp), %esi

    decl %ecx
    jnz bigdivloop

    bigdivend:

    fstp %st
    fstp %st
    fstp %st

    popl %ebp
    popl %edi
    popl %esi
    popl %ecx
    popl %ebx

    ret

.align 5
_bigshr:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx
    addl %ecx, %ecx

    jz bigshrend

    bigshrloop:
    movl -4(%esi, %ecx, 4), %eax
    rcrl $1, %eax
    movl %eax, -4(%edi, %ecx, 4)
    decl %ecx
    jnz bigshrloop

    bigshrend:

    movl $0, %eax
    adcl $0, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

.align 5
_bigcmp:
    pushl %ecx
    pushl %esi
    pushl %edi

    movl 16(%esp), %edi
    movl 20(%esp), %esi
    movl 24(%esp), %ecx
    addl %ecx, %ecx

    jz bigcmpend

    subl $4, %edi
    subl $4, %esi

    bigcmploop:
    movl (%edi, %ecx, 4), %eax
    cmpl (%esi, %ecx, 4), %eax
    jb bigcmpb
    ja bigcmpa
    decl %ecx
    jnz bigcmploop

    bigcmpend:
    xor %eax, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

    bigcmpb:
    movl $-1, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret

    bigcmpa:
    movl $1, %eax

    popl %edi
    popl %esi
    popl %ecx

    ret
");
