#if !defined(__RAW_H)
#define __RAW_H


// The modint raw data type, unsigned if possible
typedef unsigned long long rawtype;


const rawtype MAXMODULUS = 0xFFFFFFFFFFFFFFFFULL;
const rawtype MAXRAW = 0xFFFFFFFFFFFFFFFFULL;
const int RAWBITS = 64;

// Base (must be BASEDIGIT^BASEDIGITS = BASE < all MODULI)
const rawtype BASE = 10000000000000000000ULL;
const rawtype BASEDIGIT = 10;
const int BASEDIGITS = 19;
const rawtype BASEFACTORS[] = {2, 5};           // All prime factors of BASE
const int NBASEFACTORS = 2;                     // Number of prime factors of BASE

const rawtype MODULI[3] = {18446744069414584321ULL, 18446744056529682433ULL, 18446742974197923841ULL};     // upto n = 3*2^32
const rawtype PRIMITIVEROOTS[3] = {7, 10, 19};
const rawtype WFTAMODULI[3] = {0, 0, 0};                // not used
const rawtype WFTAPRIMITIVEROOTS[3] = {0, 0, 0};

const size_t MAXTRANSFORMLENGTH = 6442450944ULL; // Maximum transform length for these moduli


// Low-level inline functions

// DOS or Linux GCC

extern "C"
{
rawtype modmul (rawtype a, rawtype b, rawtype m);
rawtype modadd (rawtype a, rawtype b, rawtype m);
rawtype modsub (rawtype a, rawtype b, rawtype m);
}


#endif  // __RAW_H
