#if !defined(__RAW_H)
#define __RAW_H


// The modint raw data type, unsigned if possible
typedef unsigned rawtype;


const rawtype MAXMODULUS = 0x7FFFFFFF;
const rawtype MAXRAW = 0xFFFFFFFF;
const int RAWBITS = 32;

// Base (must be BASEDIGIT^BASEDIGITS = BASE < all MODULI)
const rawtype BASE = 1000000000;
const rawtype BASEDIGIT = 10;
const int BASEDIGITS = 9;
const rawtype BASEFACTORS[] = {2, 5};           // All prime factors of BASE
const int NBASEFACTORS = 2;                     // Number of prime factors of BASE

const rawtype MODULI[3] = {2113929217, 2013265921, 1811939329};     // upto n = 3*2^25
const rawtype PRIMITIVEROOTS[3] = {5, 31, 13};
const rawtype WFTAMODULI[3] = {1955923201, 1676505601, 1549497601}; // upto n = 5040^2
const rawtype WFTAPRIMITIVEROOTS[3] = {29, 31, 17};

const size_t MAXTRANSFORMLENGTH = 50331648;     // Maximum transform length for these moduli


// Low-level inline functions

// DOS or Linux GCC

inline rawtype modmul (rawtype a, rawtype b, rawtype m)
{
    rawtype r;

    asm ("mull %2; divl %3" : "=&d" (r)
                            : "%a" (a), "rm" (b), "m" (m)
                            : "eax", "cc");
    return r;
}

inline rawtype modadd (rawtype a, rawtype b, rawtype m)
{
    rawtype r;

    asm ("addl %2, %1; cmpl %3, %1; jb 0f; subl %3, %1; 0:"
                            : "=&r" (r)
                            : "%0" (a), "g" (b), "g" (m)
                            : "cc");
    return r;
}

inline rawtype modsub (rawtype a, rawtype b, rawtype m)
{
    rawtype r;

    asm ("subl %2, %1; jnc 0f; addl %3, %1; 0:"
                            : "=&r" (r)
                            : "0" (a), "g" (b), "g" (m)
                            : "cc");
    return r;
}


#endif  // __RAW_H
