#include "ap.h"


// The baseint functions
// Baseints are basically bigints, but the base is not the rawtype maximum, but Base

// rawtype baseadd (rawtype *dest, rawtype *src1, rawtype *src2, size_t len, rawtype carry)
// rawtype basesub (rawtype *dest, rawtype *src1, rawtype *src2, size_t len, rawtype carry)
// rawtype basemuladd (rawtype *dest, rawtype *src1, rawtype *src2, rawtype src3, size_t len, rawtype carry)
// rawtype basediv (rawtype *dest, rawtype *src1, rawtype src2, size_t len, rawtype carry)

asm ("
    .globl baseadd
    .globl basesub
    .globl basemuladd
    .globl basediv

.align 16
baseadd:
    pushl %ebx
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 28(%esp), %edi
    movl 32(%esp), %esi
    movl 36(%esp), %ebx
    movl 40(%esp), %ecx
    movl 44(%esp), %eax

    testl %ecx, %ecx
    jz baseaddend

    baseaddloop:
    movl -4(%esi, %ecx, 4), %edx
    decl %ecx
    movl Base, %ebp
    addl %eax, %edx

    testl %ebx, %ebx
    jz baseaddloopnosrc2
    addl (%ebx, %ecx, 4), %edx
    baseaddloopnosrc2:

    subl %ebp, %edx
    sbbl %eax, %eax

    andl %eax, %ebp
    incl %eax
    addl %ebp, %edx

    testl %ecx, %ecx
    movl %edx, (%edi, %ecx, 4)
    jnz baseaddloop

    baseaddend:

    popl %ebp
    popl %edi
    popl %esi
    popl %edx
    popl %ecx
    popl %ebx

    ret

.align 16
basesub:
    pushl %ebx
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 28(%esp), %edi
    movl 32(%esp), %esi
    movl 36(%esp), %ebx
    movl 40(%esp), %ecx
    movl 44(%esp), %eax

    testl %ecx, %ecx
    jz basesubend

    basesubloop:
    xorl %edx, %edx
    decl %ecx
    testl %esi, %esi
    jz basesubloopnosrc1
    movl (%esi, %ecx, 4), %edx
    basesubloopnosrc1:

    testl %ebx, %ebx
    jz basesubloopnosrc2
    addl (%ebx, %ecx, 4), %eax
    basesubloopnosrc2:

    subl %eax, %edx
    movl Base, %ebp

    sbbl %eax, %eax

    andl %eax, %ebp
    negl %eax
    addl %ebp, %edx

    testl %ecx, %ecx
    movl %edx, (%edi, %ecx, 4)
    jnz basesubloop

    basesubend:

    popl %ebp
    popl %edi
    popl %esi
    popl %edx
    popl %ecx
    popl %ebx

    ret

.align 16
basemuladd:
    pushl %ebx
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi
    pushl %ebp

    movl 28(%esp), %edi
    movl 32(%esp), %esi
    movl 36(%esp), %ebx
    movl 44(%esp), %ecx
    movl 48(%esp), %eax

    testl %ecx, %ecx
    jz basemuladdend

    basemuladdloop:
    movl %eax, %ebp
    movl -4(%esi, %ecx, 4), %eax
    mull 40(%esp)
    decl %ecx
    addl %ebp, %eax
    adcl $0, %edx

    testl %ebx, %ebx
    jz basemuladdloopnosrc2
    addl (%ebx, %ecx, 4), %eax
    adcl $0, %edx
    basemuladdloopnosrc2:

    movl Base, %ebp
    cmpl $0x40000000, %ebp
    jne basemuladdloopnofast
    movl %eax, %ebp
    andl $0x3FFFFFFF, %ebp
    shrdl $30, %edx, %eax
    movl %ebp, %edx
    jmp basemuladdloopfast
    basemuladdloopnofast:
    divl %ebp
    basemuladdloopfast:

    movl %edx, (%edi, %ecx, 4)

    testl %ecx, %ecx
    jnz basemuladdloop

    basemuladdend:

    popl %ebp
    popl %edi
    popl %esi
    popl %edx
    popl %ecx
    popl %ebx

    ret

.align 16
basediv:
    pushl %ecx
    pushl %edx
    pushl %esi
    pushl %edi

    movl 20(%esp), %edi
    movl 24(%esp), %esi
    movl 32(%esp), %ecx
    movl 36(%esp), %eax

    testl %ecx, %ecx
    jz basedivend

    leal (%edi, %ecx, 4), %edi
    testl %esi, %esi
    jz basedivnosrc1
    leal (%esi, %ecx, 4), %esi
    basedivnosrc1:
    negl %ecx

    basedivloop:
    movl Base, %edx
    cmpl $0x40000000, %edx
    jne basedivloopnofast
    shldl $30, %eax, %edx
    shll $30, %eax
    jmp basedivloopfast
    basedivloopnofast:
    mull %edx
    basedivloopfast:

    testl %esi, %esi
    jz basedivloopnosrc1
    addl (%esi, %ecx, 4), %eax
    adcl $0, %edx
    basedivloopnosrc1:

    divl 28(%esp)

    movl %eax, (%edi, %ecx, 4)
    movl %edx, %eax

    incl %ecx
    jnz basedivloop

    basedivend:

    popl %edi
    popl %esi
    popl %edx
    popl %ecx

    ret
");
