#include "ap.h"


// Optimized routines for moving big blocks of data

void moveraw (void *d, void *s, size_t n)
{
    __asm
    {
        mov edi, d
        mov esi, s
        mov ecx, n

        cld

        rep movsd
    }
}

void swapraw (void *d, void *s, size_t n)
{
    __asm
    {
        mov edi, d
        mov esi, s
        mov ecx, n

        jecxz swaprawend

        swaprawloop:
        mov eax, [edi]
        mov ebx, [esi]
        mov [esi], eax
        mov [edi], ebx
        add esi, 4
        add edi, 4
        dec ecx
        jnz swaprawloop

        swaprawend:
    }
}
