#if !defined(__RAW_H)
#define __RAW_H


// The modint raw data type, unsigned if possible
typedef float rawtype;


const rawtype MAXMODULUS = 16777215.0;
const rawtype MAXRAW = 16777215.0;
const int RAWBITS = 24;

// Base (must be BASEDIGIT^BASEDIGITS = BASE < all Moduli)
const rawtype BASE = 1e7;
const rawtype BASEDIGIT = 10.0;
const int BASEDIGITS = 7;
const rawtype BASEFACTORS[] = {2.0, 5.0};       // All prime factors of BASE
const int NBASEFACTORS = 2;                     // Number of prime factors of BASE

const rawtype MODULI[3] = {16515073.0, 14942209.0, 14155777.0};         // upto n = 3*2^18
const rawtype PRIMITIVEROOTS[3] = {5.0, 11.0, 7.0};
const rawtype WFTAMODULI[3] = {15240961.0, 13789441.0, 10886401.0};     // upto n = 5040*144
const rawtype WFTAPRIMITIVEROOTS[3] = {11.0, 11.0, 13.0};

const size_t MAXTRANSFORMLENGTH = 393216;       // Maximum transform length for these moduli

extern double imodulus;


// Low-level inline functions

// Implement your own quick floor function
#define quick_floor floor
// #define quick_floor (int)


#include <math.h>

// Computes a * b % m
inline rawtype modmul (rawtype a, rawtype b, rawtype m)
{
    double r;

    r = (double) a * (double) b;

    return r - (double) m * quick_floor (imodulus * r);
}

inline rawtype modadd (rawtype a, rawtype b, rawtype m)
{
    double r;

    r = (double) a + (double) b;
    return (r >= (double) m ? r - (double) m : r);
}

inline rawtype modsub (rawtype a, rawtype b, rawtype m)
{
    rawtype r;

    r = a - b;
    return (r < 0.0f ? r + (double) m : r);
}


#endif  // __RAW_H
