#include "ap.h"


// rawtype modmul (rawtype a, rawtype b, rawtype m);
// rawtype modadd (rawtype a, rawtype b, rawtype m);
// rawtype modsub (rawtype a, rawtype b, rawtype m);
asm ("
    .globl modmul

modmul:
    push %ebx;
    push %ecx;
    push %esi;
    push %edi;

    movl 20(%esp), %eax; mull 28(%esp);
    movl %eax, %edi; movl %edx, %ebx;
    movl 28(%esp), %eax; mull 24(%esp);
    addl %eax, %ebx; movl %edx, %ecx; adcl $0, %ecx;
    movl 32(%esp), %eax; mull 20(%esp);
    addl %eax, %ebx; adcl %edx, %ecx; movl $0, %esi; adcl $0, %esi;
    movl 24(%esp), %eax; mull 32(%esp);
    addl %eax, %ecx; adcl %esi, %edx; movl %edi, %eax;
    cmpl $0xFFFFFFFF, 40(%esp); je 8f;
    cmpl $0xFFFFFFFC, 40(%esp); je 7f;

    subl %ecx, %eax;
    sbbl %edx, %ebx;
    movl %ecx, %edi;
    sbbl %esi, %esi;
    shll $8, %edi;
    shrl $24, %ecx;
    addl %edi, %ebx;
    adcl $0, %ecx;
    movl %edx, %edi;
    shll $8, %edi;
    shrl $24, %edx;
    addl %esi, %ecx;
    adcl %esi, %edx
    addl %edi, %ecx;
    adcl $0, %edx

    subl %ecx, %eax;
    sbbl %edx, %ebx;
    movl %ecx, %edi;
    sbbl %esi, %esi;
    shll $8, %edi;
    shrl $24, %ecx;
    addl %edi, %ebx;
    adcl $0, %ecx;
    movl %edx, %edi;
    shll $8, %edx;
    addl %esi, %ecx;
    addl %edx, %ecx;

    subl %ecx, %eax;
    sbbl $0, %ebx;
    movl %ecx, %edi;
    sbbl %ecx, %ecx;
    shll $8, %edi;
    addl %edi, %ebx;
    adcl $0, %ecx;

    movl 36(%esp), %esi;
    movl 40(%esp), %edx;
    subl %esi, %eax;
    sbbl %edx, %ebx;
    sbbl $0, %ecx;
    popl %edi;
    andl %ecx, %esi;
    andl %ecx, %edx;
    addl %esi, %eax;
    popl %esi;
    adcl %ebx, %edx;
    popl %ecx;
    popl %ebx;

    ret;

    7:
    subl %ecx, %eax;
    sbbl %edx, %ebx;
    movl %ecx, %edi;
    sbbl %esi, %esi;
    shll $2, %edi;
    shrl $30, %ecx;
    addl %edi, %ebx;
    adcl $0, %ecx;
    movl %edx, %edi;
    shll $2, %edi;
    shrl $30, %edx;
    addl %esi, %ecx;
    adcl %esi, %edx
    addl %edi, %ecx;
    adcl $0, %edx

    subl %ecx, %eax;
    sbbl %edx, %ebx;
    movl %ecx, %edi;
    sbbl %esi, %esi;
    shll $2, %edi;
    shrl $30, %ecx;
    addl %edi, %ebx;
    adcl $0, %ecx;
    movl %edx, %edi;
    shll $2, %edx;
    addl %esi, %ecx;
    addl %edx, %ecx;

    subl %ecx, %eax;
    sbbl $0, %ebx;
    movl %ecx, %edi;
    sbbl %ecx, %ecx;
    shll $2, %edi;
    addl %edi, %ebx;
    adcl $0, %ecx;

    movl 36(%esp), %esi;
    movl 40(%esp), %edx;
    subl %esi, %eax;
    sbbl %edx, %ebx;
    sbbl $0, %ecx;
    popl %edi;
    andl %ecx, %esi;
    andl %ecx, %edx;
    addl %esi, %eax;
    popl %esi;
    adcl %ebx, %edx;
    popl %ecx;
    popl %ebx;

    ret;

    8:
    subl %ecx, %eax;
    sbbl %edx, %ebx;
    sbbl $0, %edx;
    addl %ecx, %ebx;
    adcl $0, %edx;

    subl %edx, %eax;
    sbbl $0, %ebx;
    movl $0, %ecx;
    sbbl $0, %ecx;
    addl %edx, %ebx;
    adcl $0, %ecx;

    movl 36(%esp), %esi;
    movl 40(%esp), %edx;
    subl %esi, %eax;
    sbbl %edx, %ebx;
    sbbl $0, %ecx;
    popl %edi;
    andl %ecx, %esi;
    andl %ecx, %edx;
    addl %esi, %eax;
    popl %esi;
    adcl %ebx, %edx;
    popl %ecx;
    popl %ebx;

    ret;
");

asm ("
    .globl modadd

modadd:
    push %ebx;
    push %ecx;
    push %esi;      
    xorl %esi, %esi;

    movl 16(%esp), %eax;
    movl 20(%esp), %edx;
    movl 24(%esp), %ebx;
    movl 36(%esp), %ecx;
    addl %ebx, %eax;
    movl 28(%esp), %ebx;
    adcl %ebx, %edx;
    movl 32(%esp), %ebx;
    adcl %esi, %esi;
    subl %ebx, %eax;
    sbbl %ecx, %edx;
    sbbl $0, %esi;
    andl %esi, %ebx;
    andl %esi, %ecx;
    addl %ebx, %eax;
    popl %esi;
    adcl %ecx, %edx;
    popl %ecx;
    popl %ebx;

    ret;
");

asm ("
    .globl modsub

modsub:
    push %ebx;
    push %ecx;
    push %esi;      

    movl 16(%esp), %eax;
    movl 20(%esp), %edx;
    movl 24(%esp), %ebx;
    subl %ebx, %eax;
    movl 28(%esp), %ebx;
    sbbl %ebx, %edx;
    movl 32(%esp), %ebx;
    sbbl %esi, %esi;
    movl 36(%esp), %ecx;
    andl %esi, %ebx;
    andl %esi, %ecx;
    addl %ebx, %eax;
    popl %esi;
    adcl %ecx, %edx;
    popl %ecx;
    popl %ebx;

    ret;
");


// Overloaded modint power
// Uses standard O(log exp) scheme
// For extreme portability this quite slow, so avoid whenever possible
modint pow (modint base, rawtype exp)
{
    modint r;

    if (exp == 0) return 1;

    while (!bigshr (&exp, &exp, 1))
        base *= base;

    r = base;

    while (exp > 0)
    {
        base *= base;
        if (bigshr (&exp, &exp, 1)) r *= base;
    }

    return r;
}
