
#include <math.h>
#include <iostream.h>


void print_base(char *bla, double x, int base);

#define DMANTISSABITS 53  // number of bits in a double mantissa
int
main(int argc, char **argv)
{
    print_base("\n 1/pi=",1.0/M_PI,10);
    print_base("\n 1/pi=",1.0/M_PI,2);

    cout << "\n bitrec: \n";

    double x = tan(1.0);
    for(int k=0; k<DMANTISSABITS+2; ++k)
    {
        if ( x<0.0 )  cout << "1";
        else          cout << "0";

        x  =  2.0*x/(1.0-x*x);
    }

    cout << endl;
    return 0;
}
// --------------------------


void
print_base(char *bla, double x, int base)
//
// print x to radix base, base<=36
//
// works only for 0 <= x < 1.0
//
{
    static const char hx[] = "0123456789abcdefghijklmnopqrstuvwxyz";

    cout << bla << " base " << base << "  =\n";

    double y = fabs(x);

    // number of digits to print:
    int n = (int)(2.0+DMANTISSABITS/(log((double)(base))/log(2.0)));

    for(int i=1; i<=n; ++i)
    {
        y = (double)base*(y-floor(y));

        cout << hx[(int)floor(y)];
    }

    cout << endl;
}
// --------------------------
