#if !defined __COPY_H
#define      __COPY_H


#include "fxttypes.h"
#include "auxtempl.h"  // min()


// tuning parameter:
#define  COPY_USE_MEMCPY  0  // 0 (default) or 1 (use memcpy if possible)
#define  COPY_USE_STATIC  1  // 0 (default) or 1 (use a few bytes as scratch space)
//#define  COPY_USE_INT     0  // to come, for x86
//
#if  ( COPY_USE_MEMCPY==1 )
#include <string.h>  // memcpy()
//#warning 'FYI: copy() uses memcpy() when possibe'
#endif // COPY_USE_MEMCPY
//
#if  ( COPY_USE_STATIC==1 )
//#warning 'FYI: copy() uses static workspace to be more cache friendly'
#endif // COPY_USE_STATIC

template <typename Type>
void
swap(Type *f, Type *g, ulong n)
// swap arrays
{
    while ( n-- )
    {
        Type t(f[n]);  f[n]=g[n];  g[n]=t;
    }    
}
//-----------------------


template <typename Type>
void
copy_mem(const Type *src, Type *dst, ulong n)
// copy array using memcpy()
{
    memcpy(dst, src, n*sizeof(Type));
//  void * memcpy (void *TO, const void *FROM, size_t SIZE)
//  undefined if the two arrays TO and FROM overlap;
}
//-----------------------


template <typename Type1, typename Type2>
void
copy(const Type1 *src, Type2 *dst, ulong n)
// copy array
{
#if  ( COPY_USE_MEMCPY==1 )
//    if ( typeof(typeid(Type1)) == typeof(typeid(Type2)) )  // =--> Internal compiler error
    if ( sizeof(Type1) == sizeof(Type2) )
    {
        memcpy(dst, (Type1 *)src, n*sizeof(Type1));
    }
    else
#endif // COPY_USE_MEMCPY
    {
#if  ( COPY_USE_STATIC==1 )

        src += n;
        dst += n;
        if ( n&1 )
        {
            *(--dst) = (Type2)*(--src);
        }

        if ( n&2 )
        {
            *(--dst) = (Type2)*(--src);
            *(--dst) = (Type2)*(--src);
        }

        n /= 4;
        while ( n-- )
        {
            Type2 t0, t1, t2, t3;  // jjnote: problem with types of huge size
            t3 = (Type2)*(--src);
            t2 = (Type2)*(--src);
            t1 = (Type2)*(--src);
            t0 = (Type2)*(--src);
            *(--dst) = t3;
            *(--dst) = t2;
            *(--dst) = t1;
            *(--dst) = t0;
        }
#else
        while ( n-- )  dst[n] = (Type2)src[n];
#endif // COPY_USE_STATIC
    }
}
//-----------------------


template <typename Type1, typename Type2>
void
copy(const Type1 *src, ulong ns,
     Type2 *dst, ulong nd)
// copy as much as makes sense, fill rest with zeroes
// from src[] (length ns) to dst[] (length nd):
{
    ulong k, n;
    n = min(nd,ns);
//    for (k=0; k<n; ++k)  dst[k] = (Type2)src[k];
    copy(src, dst, n);  k = n;

    for (  ; k<nd; ++k)  dst[k] = 0;
}
//-----------------------


//template <typename Type1, typename Type2>
//void
//offset_copy(const Type1 *src, ulong ns,
//            Type2 *dst, ulong nd,
//            ulong off)
//// copy with offset
//// from src[] (length ns) to dst[] (length nd):
//{
//    if ( off>=ns )  return;  // no elements to copy from
//    if ( off>=nd )  return;  // no elements to copy to
//
//    ulong len = min(ns-off, nd-off);
//    copy(src+off, dst+off, len);
//}
////-----------------------


template <typename Type1, typename Type2>
void
skip_copy(const Type1 *src, Type2 *dst, ulong n, ulong d)
// copy n elements from src[] at positions
// [0],[d],[2d],[3d],...,[(n-1)*d]
// to dst[0, 1, ... ,n-1]
{
    for (ulong k=0,j=0; j<n; k+=d,j++)  dst[j] = src[k];
}
//-----------------------


template <typename Type1, typename Type2>
void
skip_copy_back(const Type1 *src, Type2 *dst, ulong n, ulong d)
// copy n elements from src[0, 1, ... ,n-1]
// to dst[] at positions
// [0],[d],[2d],[3d],...,[(n-1)*d]
{
    for (ulong k=0,j=0; j<n; k+=d,j++)  dst[k] = src[j];
}
//-----------------------


template <typename Type>
void
null(Type *f, ulong n)
// set array to zero:
{
    const Type v(0);
    while ( n-- )  f[n] = v;
}
//-----------------------


template <typename Type>
void
fill(Type *dst, ulong n, Type v)
// fill array with value v
{
    while (  n--  )  dst[n] = v;
}
//-----------------------

template <typename Type>
void
fill_seq(Type *dst, ulong n, Type start=0, Type step=1)
// fill array with values
// start, start+step, start+2*step, ...
{
    for (ulong k=0; k<n; ++k)
    {
        dst[k] = start;
        start += step;
    }
}
//-----------------------


#endif // !defined __COPY_H
